/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIScrollView;
import java.util.Objects;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.widget.ServerItemList;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.SearchColumnType;
import moe.plushie.armourers_workshop.library.data.impl.SearchOrderType;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HomeLibraryPanel
extends AbstractLibraryPanel
implements GlobalSkinLibraryWindow.ISkinListListener {
    private final UIScrollView scrollView = new UIScrollView(CGRect.ZERO);
    private final ServerItemList skinPanelRecentlyUploaded = this.buildFileList(0.0f, 0.0f, 300.0f, 307.0f);
    private final ServerItemList skinPanelMostDownloaded = this.buildFileList(0.0f, 0.0f, 300.0f, 307.0f);
    private final ServerItemList skinPanelTopRated = this.buildFileList(0.0f, 0.0f, 300.0f, 307.0f);
    private final ServerItemList skinPanelNeedRated = this.buildFileList(0.0f, 0.0f, 300.0f, 307.0f);
    private int lastRequestSize = 0;
    private final GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();

    public HomeLibraryPanel() {
        super("skin-library-global.home", GlobalSkinLibraryWindow.Page.HOME::equals);
        this.setup();
    }

    private void setup() {
        this.scrollView.setFrame(this.bounds());
        this.scrollView.setAutoresizingMask(18);
        this.scrollView.setContentSize(new CGSize(0.0f, 1000.0f));
        this.scrollView.setContentOffset(new CGPoint(0.0f, 20.0f));
        this.addSubview(this.scrollView);
        this.scrollView.addSubview(this.skinPanelRecentlyUploaded);
        this.scrollView.addSubview(this.skinPanelTopRated);
        this.scrollView.addSubview(this.skinPanelNeedRated);
        this.scrollView.addSubview(this.skinPanelMostDownloaded);
        this.buildTitle(this.skinPanelRecentlyUploaded, "recentlyUploaded");
        this.buildTitle(this.skinPanelMostDownloaded, "mostDownloaded");
        this.buildTitle(this.skinPanelTopRated, "topRated");
        this.buildTitle(this.skinPanelNeedRated, "needRated");
        UIButton button = new UIButton(new CGRect(4.0f, 6.0f, 80.0f, 16.0f));
        button.setTitle(this.getDisplayText("showAllSkins", new Object[0]), 0);
        button.setTitleColor(UIColor.WHITE, 0);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, HomeLibraryPanel::showAll);
        this.scrollView.addSubview(button);
        this.setNeedsLayout();
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        float listTop = 20.0f;
        float listLeft = 4.0f;
        float width = this.bounds().width();
        for (ServerItemList fileList : this.lists()) {
            fileList.setFrame(new CGRect(listLeft, listTop + 20.0f, width, 307.0f));
            fileList.setItemSize(new CGSize(50.0f, 50.0f));
            fileList.setBackgroundColor(0);
            fileList.setShowsName(false);
            fileList.reloadData();
            listTop = fileList.frame().maxY();
        }
        this.scrollView.setContentSize(new CGSize(0.0f, listTop + 4.0f));
        this.scrollView.setContentOffset(this.scrollView.contentOffset());
        int pageSize = this.skinPanelRecentlyUploaded.getTotalCount();
        if (this.lastRequestSize > 0 && this.lastRequestSize < pageSize) {
            this.reloadData();
        }
    }

    public void reloadData() {
        int requestSize;
        this.lastRequestSize = requestSize = this.skinPanelRecentlyUploaded.getTotalCount();
        ModLog.debug("refresh home skin list, page size: {}", this.lastRequestSize);
        this.library.searchSkin("", 0, requestSize, SearchColumnType.DATE_CREATED, SearchOrderType.DESC, SkinTypes.UNKNOWN, (result, exception) -> {
            if (result != null) {
                this.skinPanelRecentlyUploaded.setEntries(result.getSkins());
                this.skinPanelRecentlyUploaded.reloadData();
            }
        });
        this.library.searchSkin("", 0, requestSize, SearchColumnType.DOWNLOADS, SearchOrderType.DESC, SkinTypes.UNKNOWN, (result, exception) -> {
            if (result != null) {
                this.skinPanelMostDownloaded.setEntries(result.getSkins());
                this.skinPanelMostDownloaded.reloadData();
            }
        });
        this.library.searchSkin("", 0, requestSize, SearchColumnType.RATING, SearchOrderType.DESC, SkinTypes.UNKNOWN, (result, exception) -> {
            if (result != null) {
                this.skinPanelTopRated.setEntries(result.getSkins());
                this.skinPanelTopRated.reloadData();
            }
        });
        this.library.searchSkin("", 0, requestSize, SearchColumnType.RATING_COUNT, SearchOrderType.ASC, SkinTypes.UNKNOWN, (result, exception) -> {
            if (result != null) {
                this.skinPanelNeedRated.setEntries(result.getSkins());
                this.skinPanelNeedRated.reloadData();
            }
        });
    }

    @Override
    public void skinDidChange(String skinId, @Nullable ServerSkin newValue) {
        if (newValue != null) {
            return;
        }
        for (ServerItemList fileList : this.lists()) {
            if (this.indexOf(fileList, skinId) == -1) continue;
            this.reloadData();
            return;
        }
    }

    private void showAll(UIControl sender) {
        this.router.showSkinList("", SkinTypes.UNKNOWN, SearchColumnType.DATE_CREATED, SearchOrderType.DESC);
    }

    private void showSkinInfo(ServerSkin sender) {
        this.router.showSkinDetail(sender, GlobalSkinLibraryWindow.Page.HOME);
    }

    private void buildTitle(ServerItemList list, String titleKey) {
        UILabel label = new UILabel(new CGRect(1.0f, -16.0f, list.frame().width - 2.0f, 16.0f));
        label.setText(this.getDisplayText(titleKey, new Object[0]));
        label.setTextColor(UIColor.WHITE);
        label.setAutoresizingMask(2);
        list.addSubview(label);
    }

    private ServerItemList buildFileList(float x, float y, float width, float height) {
        ServerItemList fileList = new ServerItemList(new CGRect(x, y, width, height));
        fileList.setItemSize(new CGSize(50.0f, 50.0f));
        fileList.setBackgroundColor(0);
        fileList.setShowsName(false);
        fileList.setItemSelector(this::showSkinInfo);
        return fileList;
    }

    private int indexOf(ServerItemList list, String skinId) {
        return Collections.indexOf(list.getEntries(), e -> Objects.equals(e.getId(), skinId));
    }

    private Iterable<ServerItemList> lists() {
        return Collections.collect(this.scrollView.subviews(), ServerItemList.class);
    }
}

