/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Wrapper;
import moe.plushie.armourers_workshop.core.utils.OpenDistributionType;
import moe.plushie.armourers_workshop.init.environment.EnvironmentPlatformType;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.forge.EnvironmentManagerImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnvironmentManager {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion(String modId) {
        return EnvironmentManagerImpl.getModVersion(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvironmentPlatformType getPlatformType() {
        return EnvironmentManagerImpl.getPlatformType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvironmentType getEnvironmentType() {
        return EnvironmentManagerImpl.getEnvironmentType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static File getRootDirectory() {
        return EnvironmentManagerImpl.getRootDirectory();
    }

    public static File getSkinLibraryDirectory() {
        return new File(EnvironmentManager.getRootDirectory(), "skin-library");
    }

    public static File getSkinCacheDirectory() {
        return new File(EnvironmentManager.getRootDirectory(), "skin-cache");
    }

    public static File getSkinDatabaseDirectory() {
        return EnvironmentManager.getServer().m_129843_(new LevelResource("skin-database")).toFile();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getServer() {
        return EnvironmentManagerImpl.getServer();
    }

    public static OpenDistributionType getDistributionType(MinecraftServer server) {
        if (server == null) {
            return OpenDistributionType.CLIENT;
        }
        if (server.m_6982_()) {
            return OpenDistributionType.DEDICATED_SERVER;
        }
        return OpenDistributionType.INTEGRATED_SERVER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IResourceManager getResourceManager() {
        return Wrapper.asResourceManager(Minecraft.m_91087_().m_91098_());
    }

    public static boolean isDedicatedServer() {
        return EnvironmentManager.getEnvironmentType() == EnvironmentType.SERVER;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopment() {
        return EnvironmentManagerImpl.isDevelopment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isInstalled(String modId) {
        return EnvironmentManagerImpl.isInstalled(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IConfigSpec getClientConfigSpec() {
        return EnvironmentManagerImpl.getClientConfigSpec();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IConfigSpec getCommonConfigSpec() {
        return EnvironmentManagerImpl.getCommonConfigSpec();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static AbstractRegistryManager getRegistryManager() {
        return EnvironmentManagerImpl.getRegistryManager();
    }
}

