/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.TagParser;

public class TagSerializer
implements IDataSerializer {
    protected final CompoundTag tag;
    protected final IDataSerializer impl;

    public TagSerializer() {
        this(new CompoundTag());
    }

    public TagSerializer(CompoundTag tag) {
        this.tag = tag;
        this.impl = AbstractDataSerializer.wrap(tag);
    }

    public TagSerializer(InputStream inputStream) throws IOException {
        this(TagSerializer.parse(inputStream));
    }

    public static void writeToStream(IDataSerializable.Immutable value, OutputStream outputStream) throws IOException {
        TagSerializer serializer = new TagSerializer();
        value.serialize(serializer);
        TagSerializer.writeToStream(serializer.getTag(), outputStream);
    }

    public static void writeToStream(CompoundTag compoundTag, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            NbtIo.m_128941_((CompoundTag)compoundTag, (DataOutput)dataOutputStream);
        }
    }

    public static CompoundTag parse(InputStream inputStream) throws IOException {
        try (DataInputStream datainputstream = new DataInputStream(inputStream);){
            CompoundTag compoundTag = NbtIo.m_128928_((DataInput)datainputstream);
            return compoundTag;
        }
    }

    public static CompoundTag parse(String contents) {
        try {
            return TagParser.m_129359_((String)contents);
        }
        catch (Exception e) {
            return new CompoundTag();
        }
    }

    @Override
    public <T> T read(IDataSerializerKey<T> key) {
        return this.impl.read(key);
    }

    @Override
    public <T> void write(IDataSerializerKey<T> key, T value) {
        this.impl.write(key, value);
    }

    public CompoundTag getTag() {
        return this.tag;
    }
}

