/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import moe.plushie.armourers_workshop.api.client.model.IModelPartPose;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;

public class OpenModelPartPose
implements IModelPartPose {
    private float x;
    private float y;
    private float z;
    private float xRot;
    private float yRot;
    private float zRot;

    public OpenModelPartPose() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public OpenModelPartPose(float x, float y, float z, float xRot, float yRot, float zRot) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public float getXRot() {
        return this.xRot;
    }

    @Override
    public float getYRot() {
        return this.yRot;
    }

    @Override
    public float getZRot() {
        return this.zRot;
    }

    @Override
    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void setRotation(float xRot, float yRot, float zRot) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
    }

    @Override
    public void transform(IPoseStack poseStack) {
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            poseStack.translate(this.x, this.y, this.z);
        }
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.rotate(OpenQuaternionf.fromEulerAnglesZYX(this.zRot, this.yRot, this.xRot));
        }
    }
}

