/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class OpenItemTransforms
extends LinkedHashMap<String, OpenTransform3f> {
    public static IDataCodec<OpenItemTransforms> CODEC = IDataCodec.COMPOUND_TAG.xmap(OpenItemTransforms::new, OpenItemTransforms::serializeNBT);

    public OpenItemTransforms() {
    }

    public OpenItemTransforms(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            this.put(key, this.deserializeTransform(nbt.m_128437_(key, 5)));
        }
    }

    @Override
    public void put(OpenItemDisplayContext key, OpenTransform3f value) {
        this.put(key.getName(), value);
    }

    public OpenTransform3f get(OpenItemDisplayContext key) {
        return (OpenTransform3f)this.get(key.getName());
    }

    public void setOffset(OpenTransform3f offset) {
        this.put("offset", offset);
    }

    @Nullable
    public OpenTransform3f getOffset() {
        return (OpenTransform3f)this.get("offset");
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.forEach((key, value) -> nbt.m_128365_(key, (Tag)this.serializeTransform((OpenTransform3f)value)));
        return nbt;
    }

    private ListTag serializeTransform(OpenTransform3f transform) {
        ListTag tag = new ListTag();
        if (transform.isIdentity()) {
            return tag;
        }
        OpenVector3f translate = transform.translate();
        tag.add((Object)FloatTag.m_128566_((float)translate.x()));
        tag.add((Object)FloatTag.m_128566_((float)translate.y()));
        tag.add((Object)FloatTag.m_128566_((float)translate.z()));
        OpenVector3f rotation = transform.rotation();
        tag.add((Object)FloatTag.m_128566_((float)rotation.x()));
        tag.add((Object)FloatTag.m_128566_((float)rotation.y()));
        tag.add((Object)FloatTag.m_128566_((float)rotation.z()));
        OpenVector3f scale = transform.scale();
        tag.add((Object)FloatTag.m_128566_((float)scale.x()));
        tag.add((Object)FloatTag.m_128566_((float)scale.y()));
        tag.add((Object)FloatTag.m_128566_((float)scale.z()));
        return tag;
    }

    private OpenTransform3f deserializeTransform(ListTag tag) {
        if (tag.isEmpty() || tag.size() < 9) {
            return OpenTransform3f.IDENTITY;
        }
        float tx = tag.m_128775_(0);
        float ty = tag.m_128775_(1);
        float tz = tag.m_128775_(2);
        OpenVector3f translate = new OpenVector3f(tx, ty, tz);
        float rx = tag.m_128775_(3);
        float ry = tag.m_128775_(4);
        float rz = tag.m_128775_(5);
        OpenVector3f rotation = new OpenVector3f(rx, ry, rz);
        float sx = tag.m_128775_(6);
        float sy = tag.m_128775_(7);
        float sz = tag.m_128775_(8);
        OpenVector3f scale = new OpenVector3f(sx, sy, sz);
        return OpenTransform3f.create(translate, rotation, scale);
    }
}

