/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.api.core.IResource;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import org.jetbrains.annotations.Nullable;

public class JsonSerializer {
    private static final Gson GSON = new Gson();

    public static IODataObject readFromString(String jsonString) throws IOException {
        if (jsonString == null || jsonString.isEmpty()) {
            throw new IllegalArgumentException("json cannot be null or empty");
        }
        return JsonSerializer.readFromStream(new ByteArrayInputStream(jsonString.getBytes()));
    }

    public static IODataObject readFromStream(InputStream inputStream) throws IOException {
        IODataObject iODataObject;
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try {
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.setLenient(false);
            JsonObject jsonObject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
            iODataObject = IODataObject.of((JsonElement)jsonObject);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new JsonParseException((Throwable)exception);
            }
        }
        reader.close();
        return iODataObject;
    }

    @Nullable
    public static IODataObject readFromResource(IResource resource) {
        try {
            return JsonSerializer.readFromStream(resource.getInputStream());
        }
        catch (IOException exception) {
            return null;
        }
    }
}

