/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinTextureProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class SkinTextureProperties
implements ISkinTextureProperties {
    public static final SkinTextureProperties EMPTY = new SkinTextureProperties();
    private int flags = 0;
    private final SkinProperties storage = new SkinProperties();

    public void readFromStream(IInputStream stream) throws IOException {
        this.flags = stream.readInt();
        if ((this.flags & Integer.MIN_VALUE) != 0) {
            this.storage.readFromStream(stream);
        }
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        if (this.storage.isEmpty()) {
            stream.writeInt(this.flags);
        } else {
            stream.writeInt(this.flags | Integer.MIN_VALUE);
            this.storage.writeToStream(stream);
        }
    }

    public <T> void set(ISkinProperty<T> property, T value) {
        this.storage.put(property, value);
    }

    public <T> T get(ISkinProperty<T> property) {
        return this.storage.get(property);
    }

    public void setEmissive(boolean isEmissive) {
        this.setFlag(0, isEmissive);
    }

    @Override
    public boolean isEmissive() {
        return this.getFlag(0);
    }

    public void setSpecular(boolean isSpecular) {
        this.setFlag(2, isSpecular);
    }

    @Override
    public boolean isSpecular() {
        return this.getFlag(2);
    }

    public void setNormal(boolean isNormal) {
        this.setFlag(3, isNormal);
    }

    @Override
    public boolean isNormal() {
        return this.getFlag(3);
    }

    public void setBlurFilter(boolean isBlurFilter) {
        this.setFlag(4, isBlurFilter);
    }

    @Override
    public boolean isBlurFilter() {
        return this.getFlag(4);
    }

    public void setClampToEdge(boolean isClampToEdge) {
        this.setFlag(5, isClampToEdge);
    }

    @Override
    public boolean isClampToEdge() {
        return this.getFlag(5);
    }

    public SkinTextureProperties copy() {
        SkinTextureProperties properties = new SkinTextureProperties();
        properties.flags = this.flags;
        properties.storage.putAll(this.storage);
        return properties;
    }

    public String toString() {
        SkinProperties properties = this.storage.copy();
        if (this.isEmissive()) {
            properties.put("isEmissive", (Object)true);
        }
        if (this.isNormal()) {
            properties.put("isNormal", (Object)true);
        }
        if (this.isSpecular()) {
            properties.put("isSpecular", (Object)true);
        }
        if (this.isBlurFilter()) {
            properties.put("isBlurFilter", (Object)true);
        }
        if (this.isClampToEdge()) {
            properties.put("isClampToEdge", (Object)true);
        }
        return properties.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTextureProperties)) {
            return false;
        }
        SkinTextureProperties that = (SkinTextureProperties)o;
        return this.flags == that.flags && this.storage.equals(that.storage);
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.storage);
    }

    private void setFlag(int bit, boolean value) {
        this.flags = value ? (this.flags |= 1 << bit) : (this.flags &= ~(1 << bit));
    }

    private boolean getFlag(int bit) {
        return (this.flags & 1 << bit) != 0;
    }
}

