/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;

public class SkinPaintData {
    public static final int TEXTURE_OLD_WIDTH = 64;
    public static final int TEXTURE_OLD_HEIGHT = 32;
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    private final int width;
    private final int height;
    private final int[] data;

    public SkinPaintData(int width, int height) {
        this.data = new int[width * height];
        this.width = width;
        this.height = height;
    }

    public SkinPaintData(int width, int height, int[] data) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public static SkinPaintData v1() {
        return new SkinPaintData(64, 32);
    }

    public static SkinPaintData v2() {
        return new SkinPaintData(64, 64);
    }

    public SkinPaintData clone() {
        SkinPaintData paintData = new SkinPaintData(this.width, this.height);
        System.arraycopy(this.data, 0, paintData.data, 0, this.data.length);
        return paintData;
    }

    public void copyFrom(SkinPaintData paintData) {
        if (this.width != paintData.getWidth()) {
            return;
        }
        if (this.height == paintData.getHeight()) {
            System.arraycopy(paintData.getData(), 0, this.data, 0, this.data.length);
            return;
        }
        System.arraycopy(paintData.getData(), 0, this.data, 0, this.width * Math.min(this.height, paintData.getHeight()));
        if (this.height <= 32) {
            return;
        }
        EntityTextureModel source = EntityTextureModel.of(paintData.getWidth(), paintData.getHeight(), false);
        EntityTextureModel destination = EntityTextureModel.of(this.getWidth(), this.getHeight(), false);
        source.forEach((partType, sourceBox) -> {
            EntityTextureModel.Box destinationBox = destination.get((SkinPartType)partType);
            if (sourceBox.equals(destinationBox) || destinationBox == null) {
                return;
            }
            ArrayList sourceTextures = new ArrayList(0);
            sourceBox.forEach((texturePos, x, y, z, dir) -> sourceTextures.add(texturePos));
            destinationBox.forEach((texture, x, y, z, dir) -> {
                if (!sourceTextures.isEmpty()) {
                    int color = paintData.getColor((OpenVector2i)sourceTextures.remove(0));
                    this.setColor(texture, color);
                }
            });
        });
    }

    public int getColor(OpenVector2i point) {
        return this.getColor(point.x(), point.y());
    }

    public void setColor(OpenVector2i point, int color) {
        this.setColor(point.x(), point.y(), color);
    }

    public int getColor(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        return this.data[x + y * this.width];
    }

    public void setColor(int x, int y, SkinPaintColor paintColor) {
        this.setColor(x, y, paintColor.getRawValue());
    }

    public void setColor(int x, int y, int color) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.data[x + y * this.width] = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getData() {
        return this.data;
    }
}

