/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.impl;

import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer2;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTextureData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureBox;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkGeometrySerializerV2
extends ChunkGeometrySerializer {
    @Override
    public int stride(ISkinGeometryType geometryType, int options, ChunkPaletteData palette) {
        int faceCount = options & 0xF;
        return Decoder.calcStride(palette.getTextureIndexBytes(), faceCount);
    }

    @Override
    public ChunkGeometrySerializer.Encoder<?> encoder(ISkinGeometryType geometryType) {
        return new Encoder();
    }

    @Override
    public ChunkGeometrySerializer.Decoder<?> decoder(ISkinGeometryType geometryType, ChunkGeometrySlice slice) {
        return new Decoder(geometryType, slice);
    }

    protected static class Decoder
    extends SkinCube
    implements ChunkGeometrySerializer.Decoder<SkinCube> {
        private final int faceCount;
        private final ISkinGeometryType type;
        private final ChunkGeometrySlice slice;
        private final ChunkPaletteData palette;
        private final EnumMap<OpenDirection, OpenVector2f> startUVs = new EnumMap(OpenDirection.class);
        private final EnumMap<OpenDirection, OpenVector2f> endUVs = new EnumMap(OpenDirection.class);
        private final EnumMap<OpenDirection, SkinTextureOptions> optionsValues = new EnumMap(OpenDirection.class);
        private final EnumMap<OpenDirection, SkinTexturePos> texturePoss = new EnumMap(OpenDirection.class);
        private OpenTransform3f transform = OpenTransform3f.IDENTITY;

        public Decoder(ISkinGeometryType type, ChunkGeometrySlice slice) {
            this.type = type;
            this.palette = slice.getPalette();
            this.slice = slice;
            this.faceCount = slice.getGeometryOptions() & 0xF;
        }

        public static int calcStride(int usedBytes, int size) {
            return 88 + (1 + usedBytes * 2) * size;
        }

        @Override
        public SkinCube begin() {
            return this;
        }

        @Override
        public ISkinGeometryType getType() {
            return this.type;
        }

        @Override
        public OpenRectangle3f getBoundingBox() {
            if (this.slice.once(0)) {
                this.boundingBox = this.slice.getRectangle3f(0);
            }
            return this.boundingBox;
        }

        @Override
        public OpenTransform3f getTransform() {
            if (this.slice.once(1)) {
                this.transform = this.slice.getTransform(24);
            }
            return this.transform;
        }

        @Override
        public SkinPaintColor getPaintColor(OpenDirection dir) {
            SkinTexturePos key = this.getTexture(dir);
            if (key != null) {
                return SkinPaintColor.WHITE;
            }
            return SkinPaintColor.CLEAR;
        }

        @Override
        public SkinTexturePos getTexture(OpenDirection dir) {
            if (this.slice.once(2)) {
                this.parseTextures();
            }
            return this.texturePoss.get(dir);
        }

        @Override
        public SkinCubeFace getFace(OpenDirection dir) {
            if (this.getTexture(dir) != null) {
                return super.getFace(dir);
            }
            return null;
        }

        protected void parseTextures() {
            this.startUVs.clear();
            this.endUVs.clear();
            this.optionsValues.clear();
            this.texturePoss.clear();
            SkinTextureBox textureBox = null;
            int usedBytes = this.palette.getTextureIndexBytes();
            for (int i = 0; i < this.faceCount; ++i) {
                ChunkTextureData.TextureRef ref;
                int index = Decoder.calcStride(usedBytes, i);
                byte face = this.slice.getByte(index);
                if ((face & 0x40) != 0) {
                    SkinTextureOptions opt = this.slice.getTextureOptions(index + 1);
                    for (OpenDirection dir : OpenDirection.valuesFromSet(face)) {
                        this.optionsValues.put(dir, opt);
                    }
                    continue;
                }
                OpenVector2f pos = this.slice.getTexturePos(index + 1);
                for (OpenDirection dir : OpenDirection.valuesFromSet(face)) {
                    this.endUVs.put(dir, pos);
                    if (this.startUVs.containsKey(dir)) continue;
                    this.startUVs.put(dir, pos);
                }
                if ((face & 0x80) == 0 || (ref = this.palette.readTexture(pos)) == null) continue;
                OpenRectangle3f rect = this.getBoundingBox();
                float width = rect.width();
                float height = rect.height();
                float depth = rect.depth();
                textureBox = new SkinTextureBox(width, height, depth, false, ref.getPos(), ref.getProvider());
            }
            for (OpenDirection dir : OpenDirection.values()) {
                OpenVector2f start = this.startUVs.get(dir);
                OpenVector2f end = this.endUVs.get(dir);
                if (start != null && end != null) {
                    SkinTextureOptions opt = this.optionsValues.get(dir);
                    ChunkTextureData.TextureRef ref = this.palette.readTexture(start);
                    if (ref == null) continue;
                    float u = ref.getU();
                    float v = ref.getV();
                    float width = end.x() - start.x();
                    float height = end.y() - start.y();
                    this.texturePoss.put(dir, new SkinTexturePos(u, v, width, height, opt, ref.getProvider()));
                    continue;
                }
                if (textureBox == null) continue;
                this.texturePoss.put(dir, textureBox.getTexture(dir));
            }
        }
    }

    protected static class Encoder
    implements ChunkGeometrySerializer.Encoder<SkinCube> {
        private OpenRectangle3f boundingBox = OpenRectangle3f.ZERO;
        private OpenTransform3f transform = OpenTransform3f.IDENTITY;
        private final SortedMap<OpenVector2f> startValues = new SortedMap();
        private final SortedMap<OpenVector2f> endValues = new SortedMap();
        private final SortedMap<SkinTextureOptions> optionsValues = new SortedMap();

        protected Encoder() {
        }

        @Override
        public int begin(SkinCube geometry) {
            for (OpenDirection dir : OpenDirection.values()) {
                SkinTexturePos value = geometry.getTexture(dir);
                if (value == null) continue;
                SkinTextureData provider = value.getProvider();
                if (value instanceof SkinTextureBox.Entry) {
                    SkinTextureBox.Entry entry = (SkinTextureBox.Entry)value;
                    this.startValues.put(128, entry.getParent(), provider);
                    continue;
                }
                int face = 1 << dir.get3DDataValue();
                float u = value.getU();
                float v = value.getV();
                float s = value.getWidth();
                float t = value.getHeight();
                this.startValues.put(face, new OpenVector2f(u, v), provider);
                this.endValues.put(face, new OpenVector2f(u + s, v + t), provider);
                if (value.getOptions() == null) continue;
                this.optionsValues.put(face, value.getOptions(), provider);
            }
            this.transform = geometry.getTransform();
            this.boundingBox = geometry.getBoundingBox();
            return this.startValues.size() + this.endValues.size() + this.optionsValues.size();
        }

        @Override
        public void end(ChunkPaletteData palette, ChunkDataOutputStream stream) throws IOException {
            stream.writeRectangle3f(this.boundingBox);
            stream.writeTransformf(this.transform);
            this.optionsValues.forEach((key, value) -> {
                stream.writeByte(0x40 | value);
                stream.writeVariable(palette.writeTextureOptions((SkinTextureOptions)key.getKey(), (SkinTextureData)key.getValue()));
            });
            this.startValues.forEach((key, value) -> {
                stream.writeByte((int)value);
                stream.writeVariable(palette.writeTexture((OpenVector2f)key.getKey(), (SkinTextureData)key.getValue()));
            });
            this.endValues.forEach((key, value) -> {
                stream.writeByte((int)value);
                stream.writeVariable(palette.writeTexture((OpenVector2f)key.getKey(), (SkinTextureData)key.getValue()));
            });
            this.startValues.clear();
            this.endValues.clear();
            this.optionsValues.clear();
        }
    }

    protected static class SortedMap<T> {
        private final LinkedHashMap<Pair<T, SkinTextureData>, Integer> impl = new LinkedHashMap();

        protected SortedMap() {
        }

        public void forEach(IOConsumer2<Pair<T, SkinTextureData>, Integer> consumer) throws IOException {
            for (Map.Entry<Pair<T, SkinTextureData>, Integer> entry : this.impl.entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }

        public void put(int face, T pos, SkinTextureData provider) {
            Pair index = Pair.of(pos, (Object)provider);
            int newFace = this.impl.getOrDefault(index, 0);
            this.impl.put(index, newFace |= face);
        }

        public void clear() {
            this.impl.clear();
        }

        public int size() {
            return this.impl.size();
        }
    }
}

