/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometrySet;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.impl.ChunkGeometrySerializerV1;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.impl.ChunkGeometrySerializerV2;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.impl.ChunkGeometrySerializerV3;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class ChunkGeometrySerializers {
    private static final Map<ISkinGeometryType, ChunkGeometrySerializer> SERIALIZERS = Collections.immutableMap(builder -> {
        builder.put((Object)SkinGeometryTypes.BLOCK_SOLID, (Object)new ChunkGeometrySerializerV1());
        builder.put((Object)SkinGeometryTypes.BLOCK_GLOWING, (Object)new ChunkGeometrySerializerV1());
        builder.put((Object)SkinGeometryTypes.BLOCK_GLASS, (Object)new ChunkGeometrySerializerV1());
        builder.put((Object)SkinGeometryTypes.BLOCK_GLASS_GLOWING, (Object)new ChunkGeometrySerializerV1());
        builder.put((Object)SkinGeometryTypes.CUBE, (Object)new ChunkGeometrySerializerV2());
        builder.put((Object)SkinGeometryTypes.CUBE_CULL, (Object)new ChunkGeometrySerializerV2());
        builder.put((Object)SkinGeometryTypes.MESH, (Object)new ChunkGeometrySerializerV3());
        builder.put((Object)SkinGeometryTypes.MESH_CULL, (Object)new ChunkGeometrySerializerV3());
    });

    public static ChunkGeometrySerializer getSerializer(ISkinGeometryType geometryType) {
        return SERIALIZERS.get(geometryType);
    }

    public static int getStride(ISkinGeometryType geometryType, int options, ChunkPaletteData palette) {
        return ChunkGeometrySerializers.getSerializer(geometryType).stride(geometryType, options, palette);
    }

    public static ChunkGeometrySerializer.Encoder<?> createEncoder(ISkinGeometryType geometryType) {
        return ChunkGeometrySerializers.getSerializer(geometryType).encoder(geometryType);
    }

    public static ChunkGeometrySerializer.Decoder<?> createDecoder(ISkinGeometryType geometryType, ChunkGeometrySlice slice) {
        return ChunkGeometrySerializers.getSerializer(geometryType).decoder(geometryType, slice);
    }

    public static ChunkContext createEncodeContext(Skin skin, SkinFileOptions options) {
        ChunkContext context = new ChunkContext(options);
        context.setFastEncoder(ChunkGeometrySerializers.canFastEncoding(skin.getId(), skin.getParts()));
        return context;
    }

    public static ChunkContext createDecodeContext(SkinFileOptions options) {
        return new ChunkContext(options);
    }

    public static boolean canFastEncoding(int skinOwner, List<SkinPart> parts) {
        HashSet<Integer> owners = new HashSet<Integer>();
        owners.add(skinOwner);
        Collections.eachTree(parts, SkinPart::getChildren, part -> {
            ISkinGeometrySet geometries = part.getGeometries();
            if (!geometries.isEmpty()) {
                owners.add(((SkinGeometrySet)geometries).getId());
            }
        });
        return owners.size() <= 1;
    }
}

