/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.Collection;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.Chunk;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCondition;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkConditionResult;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.utils.Objects;
import org.jetbrains.annotations.Nullable;

public class ChunkWriter {
    protected final ChunkDataOutputStream stream;

    public ChunkWriter(ChunkDataOutputStream stream) {
        this.stream = stream;
    }

    public <V> void write(ChunkSerializer<V, Void> serializer, @Nullable V value) throws IOException {
        this.write(serializer, value, null);
    }

    public <V, T> void write(ChunkSerializer<V, T> serializer, @Nullable V value, T context) throws IOException {
        ChunkSerializer.Encoder encoder = serializer.createEncoder(value, context, this.stream.getContext());
        ChunkCondition condition = Condition.of(value, serializer.getDefaultValue());
        this.stream.ifTask(condition, () -> {
            String name = serializer.getChunkType().getName();
            ChunkFlags flags = serializer.getChunkFlags(value, this.stream.getContext());
            Sum sum = new Sum();
            this.stream.writeVariable(sum);
            this.stream.sumTask(sum, () -> {
                this.writeHeader(name, flags);
                this.stream.compressTask(flags, () -> encoder.encode(value, context, this.stream));
                this.writeFooter(name, flags);
            });
        });
    }

    public void writeBlobs(Object blobs) throws IOException {
        if (blobs instanceof Collection) {
            Collection allBlobs = (Collection)blobs;
            for (Object blob : allBlobs) {
                if (!(blob instanceof Chunk)) continue;
                Chunk chunk = (Chunk)blob;
                String name = chunk.getName();
                ChunkFlags flags = chunk.getFlags();
                this.stream.writeInt(chunk.getLength());
                this.writeHeader(name, flags);
                chunk.writeToStream(this.stream);
                this.writeFooter(name, flags);
            }
        }
    }

    protected void writeHeader(String name, ChunkFlags flags) throws IOException {
        this.stream.writeString(name, 4);
        flags.writeToStream(this.stream);
    }

    protected void writeFooter(String name, ChunkFlags flags) throws IOException {
    }

    private static class Condition
    implements ChunkCondition {
        private static final Condition PASS = new Condition(ChunkConditionResult.PASS);
        private static final Condition FAILURE = new Condition(ChunkConditionResult.FAILURE);
        private final ChunkConditionResult result;

        public Condition(ChunkConditionResult result) {
            this.result = result;
        }

        public static <V> ChunkCondition of(V value, V defaultValue) {
            Collection collection;
            if (value instanceof ChunkCondition) {
                ChunkCondition condition = (ChunkCondition)value;
                return condition;
            }
            if (value instanceof Collection && (collection = (Collection)value).isEmpty()) {
                return FAILURE;
            }
            if (value == null || Objects.equals(value, defaultValue)) {
                return FAILURE;
            }
            return PASS;
        }

        @Override
        public ChunkConditionResult getResult() {
            return this.result;
        }
    }

    private static class Sum
    implements IntConsumer,
    ChunkVariable {
        private int length = 0;
        private boolean resolved = false;

        private Sum() {
        }

        @Override
        public void accept(int length) {
            this.length = length;
            this.resolved = true;
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            stream.writeInt(this.length + 4);
        }

        @Override
        public boolean freeze() {
            return this.resolved;
        }
    }
}

