/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;

public class ChunkTransform {
    private static final float[] IDENTITY_MATRIX_BUFFER = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] IDENTITY_VECTOR_BUFFER = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private OpenVector3f translate;
    private OpenVector3f rotation;
    private OpenVector3f scale;
    private OpenVector3f afterTranslate;
    private OpenVector3f pivot;
    private FloatBuffer buffer;

    public ChunkTransform() {
    }

    public ChunkTransform(OpenTransform3f transform) {
        if (transform.isIdentity()) {
            this.setIdentity();
            return;
        }
        this.translate = transform.translate();
        this.rotation = transform.rotation();
        this.scale = transform.scale();
        this.afterTranslate = transform.afterTranslate();
        this.pivot = transform.pivot();
    }

    public ChunkTransform(FloatBuffer buffer) {
        this.buffer = buffer;
    }

    public static ChunkTransform of(ITransform transform) {
        if (transform instanceof OpenTransform3f) {
            return new ChunkTransform((OpenTransform3f)transform);
        }
        return ChunkTransform.flat(transform);
    }

    public static ChunkTransform flat(ITransform transform) {
        FloatBuffer buffer = FloatBuffer.allocate(16);
        OpenPoseStack poseStack = new OpenPoseStack();
        transform.apply(poseStack);
        poseStack.last().pose().store(buffer);
        return new ChunkTransform(buffer);
    }

    public void readFromStream(ChunkDataInputStream stream) throws IOException {
        byte flags = stream.readByte();
        if ((flags & 0x10) != 0) {
            this.setIdentity();
            return;
        }
        if ((flags & 0x20) != 0) {
            this.buffer = FloatBuffer.allocate(16);
            ChunkTransform.readZippedBuffer(stream, this.buffer, IDENTITY_MATRIX_BUFFER);
            return;
        }
        FloatBuffer buffer = FloatBuffer.allocate(IDENTITY_VECTOR_BUFFER.length);
        ChunkTransform.readZippedBuffer(stream, buffer, IDENTITY_VECTOR_BUFFER);
        this.translate = ChunkTransform.readVector(buffer, 0);
        this.rotation = ChunkTransform.readVector(buffer, 3);
        this.scale = ChunkTransform.readVector(buffer, 6);
        this.afterTranslate = ChunkTransform.readVector(buffer, 9);
        this.pivot = ChunkTransform.readVector(buffer, 12);
    }

    public void writeToStream(ChunkDataOutputStream stream) throws IOException {
        if (this.isIdentity()) {
            stream.writeByte(16);
            return;
        }
        if (this.buffer != null) {
            stream.writeByte(32);
            ChunkTransform.writeZippedBuffer(stream, this.buffer, IDENTITY_MATRIX_BUFFER);
            return;
        }
        stream.writeByte(64);
        FloatBuffer buffer = FloatBuffer.allocate(IDENTITY_VECTOR_BUFFER.length);
        buffer.put(this.translate.x()).put(this.translate.y()).put(this.translate.z());
        buffer.put(this.rotation.x()).put(this.rotation.y()).put(this.rotation.z());
        buffer.put(this.scale.x()).put(this.scale.y()).put(this.scale.z());
        buffer.put(this.afterTranslate.x()).put(this.afterTranslate.y()).put(this.afterTranslate.z());
        buffer.put(this.pivot.x()).put(this.pivot.y()).put(this.pivot.z());
        buffer.rewind();
        ChunkTransform.writeZippedBuffer(stream, buffer, IDENTITY_VECTOR_BUFFER);
    }

    public void setIdentity() {
        this.pivot = null;
        this.translate = null;
        this.scale = null;
        this.rotation = null;
        this.buffer = null;
    }

    public boolean isIdentity() {
        return this.buffer == null && this.scale == null;
    }

    public ITransform build() {
        if (this.isIdentity()) {
            return OpenTransform3f.IDENTITY;
        }
        if (this.buffer != null) {
            OpenMatrix4f pose = new OpenMatrix4f(this.buffer);
            OpenMatrix3f normal = new OpenMatrix3f(this.buffer);
            return new FlatTransform(pose, normal);
        }
        return OpenTransform3f.create(this.translate, this.rotation, this.scale, this.pivot, this.afterTranslate);
    }

    private static OpenVector3f readVector(FloatBuffer buffer, int offset) {
        float x = buffer.get(offset);
        float y = buffer.get(offset + 1);
        float z = buffer.get(offset + 2);
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return OpenVector3f.ZERO;
        }
        if (x == 1.0f && y == 1.0f && z == 1.0f) {
            return OpenVector3f.ONE;
        }
        return new OpenVector3f(x, y, z);
    }

    private static void readZippedBuffer(ChunkDataInputStream stream, FloatBuffer bufferOut, float[] bufferDef) throws IOException {
        short flags = stream.readShort();
        for (int i = 0; i < bufferDef.length; ++i) {
            if ((flags & 1 << i) == 0) {
                bufferOut.put(i, stream.readFloat());
                continue;
            }
            bufferOut.put(i, bufferDef[i]);
        }
        bufferOut.rewind();
    }

    private static void writeZippedBuffer(ChunkDataOutputStream stream, FloatBuffer bufferIn, float[] bufferDef) throws IOException {
        int i;
        int flags = 0;
        for (i = 0; i < bufferDef.length; ++i) {
            if (bufferDef[i] != bufferIn.get(i)) continue;
            flags |= 1 << i;
        }
        stream.writeShort(flags);
        for (i = 0; i < bufferDef.length; ++i) {
            if ((flags & 1 << i) != 0) continue;
            stream.writeFloat(bufferIn.get(i));
        }
    }

    public static class FlatTransform
    implements ITransform {
        private final OpenMatrix4f pose;
        private final OpenMatrix3f normal;

        public FlatTransform(OpenMatrix4f pose, OpenMatrix3f normal) {
            this.pose = pose;
            this.normal = normal;
        }

        @Override
        public void apply(IPoseStack poseStack) {
            poseStack.multiply(this.normal);
            poseStack.multiply(this.pose);
        }
    }
}

