/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.Chunk;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;

public class ChunkReader {
    protected final ChunkDataInputStream stream;
    protected final Predicate<String> chunkFilter;
    protected final ArrayList<Entry> entries = new ArrayList();

    public ChunkReader(ChunkDataInputStream stream, Predicate<String> chunkFilter) {
        this.stream = stream;
        this.chunkFilter = chunkFilter;
    }

    protected void prepare() throws IOException {
        int length;
        while ((length = this.stream.readInt()) != 0) {
            EntryBuilder builder = new EntryBuilder(length);
            this.readHeader(builder);
            if (this.chunkFilter != null && !this.chunkFilter.test(builder.name)) {
                this.stream.skipBytes(builder.getBodySize());
                this.readFooter(builder);
                continue;
            }
            builder.buffer = this.stream.readBytes(builder.getBodySize());
            this.readFooter(builder);
            this.entries.add(builder.build(this.stream.getContext()));
        }
    }

    public <T> T read(ChunkSerializer<T, Void> serializer) throws IOException {
        return this.read(serializer, null);
    }

    public <T, C> T read(ChunkSerializer<T, C> serializer, C context) throws IOException {
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            ChunkSerializer.Decoder<T, C> decoder = serializer.createDecoder(entry.getName());
            if (decoder == null) continue;
            iterator.remove();
            return decoder.decode(entry.getInputStream(), context);
        }
        return serializer.getDefaultValue();
    }

    public <T> Collection<T> readAll(ChunkSerializer<T, Void> serializer) throws IOException {
        return this.readAll(serializer, null);
    }

    public <T, C> Collection<T> readAll(ChunkSerializer<T, C> serializer, C context) throws IOException {
        ArrayList<T> results = new ArrayList<T>();
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            ChunkSerializer.Decoder<T, C> decoder = serializer.createDecoder(entry.getName());
            if (decoder == null) continue;
            iterator.remove();
            results.add(decoder.decode(entry.getInputStream(), context));
        }
        return results;
    }

    public Object readBlobs() throws IOException {
        if (!this.entries.isEmpty()) {
            return new ArrayList<Entry>(this.entries);
        }
        return null;
    }

    protected void readHeader(EntryBuilder builder) throws IOException {
        builder.name = this.stream.readString(4);
        builder.flags = ChunkFlags.readFromStream(this.stream);
    }

    protected void readFooter(EntryBuilder builder) throws IOException {
    }

    protected static class EntryBuilder {
        String name;
        ChunkFlags flags;
        int length;
        int header = 10;
        ByteBuf buffer;
        Object extra;

        EntryBuilder(int length) {
            this.length = length;
        }

        public Entry build(ChunkContext context) {
            return new Entry(this.name, this.flags, this.length, this.buffer, this.extra, context);
        }

        public int getBodySize() {
            return this.length - this.header;
        }
    }

    protected static class Entry
    implements Chunk {
        protected final String name;
        protected final ChunkFlags flags;
        protected final int length;
        protected final ByteBuf buffer;
        protected ChunkDataInputStream inputStream;
        protected final ChunkContext context;
        protected final Object extra;

        public Entry(String name, ChunkFlags flags, int length, ByteBuf buffer, Object extra, ChunkContext context) {
            this.length = length;
            this.name = name;
            this.flags = flags;
            this.buffer = buffer;
            this.extra = extra;
            this.context = context;
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            stream.writeBytes(this.buffer);
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ChunkFlags getFlags() {
            return this.flags;
        }

        public ChunkDataInputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new ChunkDataInputStream(new DataInputStream(this.context.createInputStream(this.buffer, this.flags)), this.context, null);
            }
            return this.inputStream;
        }
    }
}

