/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer2;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometryData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPartReader;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPartWriter;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkReader;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTransform;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkWriter;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkPartData {
    final ChunkGeometryData geometryData;

    public ChunkPartData(ChunkGeometryData geometryData) {
        this.geometryData = geometryData;
    }

    public List<SkinPart> readFromStream(ChunkDataInputStream stream, IOConsumer2<ChunkReader, SkinPart.Builder> consumer) throws IOException {
        ChunkTransform chunkTransform = new ChunkTransform();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        LinkedHashMap<Integer, Integer> relationship = new LinkedHashMap<Integer, Integer>();
        int count = stream.readVarInt();
        for (int i = 0; i < count; ++i) {
            int id = stream.readVarInt();
            int parentId = stream.readVarInt();
            String name = stream.readString();
            SkinPartType partType = stream.readType(SkinPartTypes::byName);
            chunkTransform.readFromStream(stream);
            SkinGeometrySet<?> geometries = this.geometryData.readReferenceFromStream(stream);
            SkinPart.Builder builder = new SkinPart.Builder(partType);
            builder.name(name);
            builder.geometries(geometries);
            builder.transform(chunkTransform.build());
            pairs.add(Pair.of((Object)id, (Object)builder));
            relationship.put(id, parentId);
        }
        return stream.readChunk(ChunkPartReader::new, it -> {
            HashMap<Integer, SkinPart> mapping = new HashMap<Integer, SkinPart>();
            ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
            for (Pair pair : pairs) {
                it.prepare((Integer)pair.getKey());
                consumer.accept((ChunkReader)it, (SkinPart.Builder)pair.getValue());
                SkinPart part = ((SkinPart.Builder)pair.getValue()).build();
                mapping.put((Integer)pair.getKey(), part);
                parts.add(part);
            }
            for (Map.Entry entry : relationship.entrySet()) {
                SkinPart child = (SkinPart)mapping.get(entry.getKey());
                SkinPart parent = (SkinPart)mapping.get(entry.getValue());
                if (child == null || parent == null || child == parent) continue;
                parent.addPart(child);
                parts.remove(child);
            }
            return parts;
        });
    }

    public void writeToStream(ChunkDataOutputStream stream, List<SkinPart> parts, IOConsumer2<ChunkWriter, SkinPart> consumer) throws IOException {
        HashMap relationship = new HashMap();
        ArrayList pairs = new ArrayList();
        this.eachPart(parts, 0, (parent, part) -> {
            int id = pairs.size() + 1;
            pairs.add(Pair.of((Object)id, (Object)part));
            relationship.put(id, (Integer)parent);
            return id;
        });
        stream.writeVarInt(pairs.size());
        for (Pair pair : pairs) {
            Integer id = (Integer)pair.getKey();
            SkinPart part2 = (SkinPart)pair.getValue();
            stream.writeVarInt(id);
            stream.writeVarInt(relationship.getOrDefault(id, 0));
            stream.writeString(part2.getName());
            stream.writeType(part2.getType());
            ChunkTransform transform = ChunkTransform.of(part2.getTransform());
            transform.writeToStream(stream);
            this.geometryData.writeReferenceToStream((SkinGeometrySet<?>)part2.getGeometries(), stream);
        }
        stream.writeChunk(ChunkPartWriter::new, it -> {
            for (Pair pair : pairs) {
                it.prepare((Integer)pair.getKey());
                consumer.accept((ChunkWriter)it, (SkinPart)pair.getValue());
            }
        });
    }

    private void eachPart(Collection<SkinPart> parts, Integer parent, BiFunction<Integer, SkinPart, Integer> consumer) {
        for (SkinPart part : parts) {
            Integer value = consumer.apply(parent, part);
            this.eachPart(part.getChildren(), value, consumer);
        }
    }
}

