/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;

public class ChunkPaintData {
    public SkinPaintData readFromStream(ChunkDataInputStream stream) throws IOException {
        int width;
        int totalHeight;
        int totalWidth;
        int flags = stream.readVarInt();
        SkinPaintData paintData = this._paintData(flags, totalWidth = stream.readVarInt(), totalHeight = stream.readVarInt());
        if (paintData == null) {
            return null;
        }
        ChunkPaletteData palette = stream.getPaletteProvider();
        while ((width = stream.readVarInt()) != 0) {
            int height = stream.readVarInt();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    paintData.setColor(x, y, palette.readColor(stream));
                }
            }
        }
        return paintData;
    }

    public void writeToStream(SkinPaintData paintData, ChunkDataOutputStream stream) throws IOException {
        int flags = this._flags(paintData);
        stream.writeVarInt(flags);
        stream.writeVarInt(paintData.getWidth());
        stream.writeVarInt(paintData.getHeight());
        int width = paintData.getWidth();
        int height = paintData.getHeight();
        stream.writeVarInt(width);
        stream.writeVarInt(height);
        ChunkPaletteData palette = stream.getPaletteProvider();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                stream.writeVariable(palette.writeColor(paintData.getColor(x, y)));
            }
        }
        stream.writeVarInt(0);
        stream.writeVarInt(0);
    }

    private int _flags(SkinPaintData paintData) {
        return 0;
    }

    private SkinPaintData _paintData(int flags, int width, int height) {
        if (width == 64 && height == 32) {
            return SkinPaintData.v1();
        }
        if (width == 64 && height == 64) {
            return SkinPaintData.v2();
        }
        return null;
    }
}

