/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometry;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.utils.OpenSliceAccessor;

public class ChunkGeometrySliceSet
extends SkinGeometrySet<SkinGeometry> {
    private final int total;
    private final ThreadLocal<OpenSliceAccessor<SkinGeometry>> accessor;
    private final List<ChunkGeometrySelector> selectors;
    private final ChunkPaletteData palette;

    public ChunkGeometrySliceSet(int id, List<ChunkGeometrySelector> selectors, ChunkPaletteData palette) {
        this.id = id;
        this.palette = palette;
        this.selectors = selectors;
        this.accessor = ThreadLocal.withInitial(() -> ChunkGeometrySliceSet.build(selectors));
        this.total = ChunkGeometrySliceSet.sum(selectors);
    }

    @Override
    public int size() {
        return this.total;
    }

    @Override
    public SkinGeometry get(int index) {
        return this.accessor.get().get(index);
    }

    @Override
    public Collection<ISkinGeometryType> getSupportedTypes() {
        HashSet<ISkinGeometryType> supportedTypes = new HashSet<ISkinGeometryType>();
        for (ChunkGeometrySelector selector : this.selectors) {
            supportedTypes.add(selector.getSection().getGeometryType());
        }
        return supportedTypes;
    }

    public ChunkPaletteData getPalette() {
        return this.palette;
    }

    public Collection<ChunkGeometrySelector> getSelectors() {
        return this.selectors;
    }

    private static int sum(Collection<ChunkGeometrySelector> elements) {
        int sum = 0;
        for (ChunkGeometrySelector element : elements) {
            sum += element.getCount();
        }
        return sum;
    }

    private static OpenSliceAccessor<SkinGeometry> build(List<ChunkGeometrySelector> selectors) {
        ArrayList providers = new ArrayList();
        int startIndex = 0;
        int endIndex = 0;
        for (ChunkGeometrySelector selector : selectors) {
            providers.add(new ChunkGeometrySlice(startIndex, endIndex += selector.getCount(), selector, (ChunkGeometrySection.Immutable)selector.getSection()));
            startIndex = endIndex;
        }
        return new OpenSliceAccessor(providers);
    }
}

