/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.util.BitSet;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometry;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializers;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.utils.OpenSliceAccessor;

public class ChunkGeometrySlice
implements OpenSliceAccessor.Provider<SkinGeometry> {
    protected int readerIndex = 0;
    protected final int startIndex;
    protected final int endIndex;
    protected final int base;
    protected final int stride;
    protected final byte[] bytes;
    protected final ChunkPaletteData palette;
    protected final ISkinGeometryType geometryType;
    protected final int geometryOptions;
    protected final BitSet flags = new BitSet();
    protected final ChunkGeometrySerializer.Decoder<?> decoder;

    public ChunkGeometrySlice(int startIndex, int endIndex, ChunkGeometrySelector selector, ChunkGeometrySection.Immutable section) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.base = selector.getIndex();
        this.stride = section.stride;
        this.geometryType = section.getGeometryType();
        this.geometryOptions = section.getGeometryOptions();
        this.bytes = section.getBytes();
        this.palette = section.getPalette();
        this.decoder = ChunkGeometrySerializers.createDecoder(this.geometryType, this);
    }

    public boolean once(int index) {
        if (this.flags.get(index)) {
            return false;
        }
        this.flags.set(index);
        return true;
    }

    @Override
    public SkinGeometry get(int index) {
        int newReaderIndex = this.stride * (this.base + index);
        if (this.readerIndex != newReaderIndex) {
            this.readerIndex = newReaderIndex;
            this.flags.clear();
        }
        return this.decoder.begin();
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    public ChunkPaletteData getPalette() {
        return this.palette;
    }

    public ISkinGeometryType getGeometryType() {
        return this.geometryType;
    }

    public int getGeometryOptions() {
        return this.geometryOptions;
    }

    public byte getByte(int offset) {
        return this.bytes[this.readerIndex + offset];
    }

    public int getInt(int offset) {
        int ch1 = this.getByte(offset + 0) & 0xFF;
        int ch2 = this.getByte(offset + 1) & 0xFF;
        int ch3 = this.getByte(offset + 2) & 0xFF;
        int ch4 = this.getByte(offset + 3) & 0xFF;
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    public float getFloat(int offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    public int getFixedInt(int offset, int usedBytes) {
        if (usedBytes == 4) {
            return this.getInt(offset);
        }
        int value = 0;
        for (int i = 0; i < usedBytes; ++i) {
            int ch = this.getByte(offset + i) & 0xFF;
            value = value << 8 | ch;
        }
        return value;
    }

    public float getFixedFloat(int offset, int usedBytes) {
        return Float.intBitsToFloat(this.getFixedInt(offset, usedBytes));
    }

    public OpenVector3f getVector3f(int offset) {
        float x = this.getFloat(offset);
        float y = this.getFloat(offset + 4);
        float z = this.getFloat(offset + 8);
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return OpenVector3f.ZERO;
        }
        if (x == 1.0f && y == 1.0f && z == 1.0f) {
            return OpenVector3f.ONE;
        }
        return new OpenVector3f(x, y, z);
    }

    public OpenRectangle3f getRectangle3f(int offset) {
        float x = this.getFloat(offset);
        float y = this.getFloat(offset + 4);
        float z = this.getFloat(offset + 8);
        float width = this.getFloat(offset + 12);
        float height = this.getFloat(offset + 16);
        float depth = this.getFloat(offset + 20);
        return new OpenRectangle3f(x, y, z, width, height, depth);
    }

    public OpenTransform3f getTransform(int offset) {
        int flags = this.getInt(offset);
        OpenVector3f translate = this.getVector3f(offset + 4);
        OpenVector3f rotation = this.getVector3f(offset + 16);
        OpenVector3f scale = this.getVector3f(offset + 28);
        OpenVector3f afterTranslate = this.getVector3f(offset + 40);
        OpenVector3f pivot = this.getVector3f(offset + 52);
        return OpenTransform3f.create(translate, rotation, scale, pivot, afterTranslate);
    }

    public SkinPaintColor getColor(int offset) {
        return this.palette.readColor(this.getFixedInt(offset, this.palette.getColorIndexBytes()));
    }

    public OpenVector2f getTexturePos(int offset) {
        int usedBytes = this.palette.getTextureIndexBytes();
        float x = this.getFixedFloat(offset, usedBytes);
        float y = this.getFixedFloat(offset + usedBytes, usedBytes);
        if (x == 0.0f && y == 0.0f) {
            return OpenVector2f.ZERO;
        }
        return new OpenVector2f(x, y);
    }

    public SkinTextureOptions getTextureOptions(int offset) {
        int usedBytes = this.palette.getTextureIndexBytes();
        int x = this.getFixedInt(offset, usedBytes);
        int y = this.getFixedInt(offset + usedBytes, usedBytes);
        return new SkinTextureOptions((long)y << 32 | (long)x);
    }
}

