/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializers;

public abstract class ChunkGeometrySection {
    protected int index;
    protected int geometryTotal;
    protected boolean resolved;
    private final int geometryOptions;
    private final ISkinGeometryType geometryType;

    public ChunkGeometrySection(int geometryTotal, int geometryOptions, ISkinGeometryType geometryType) {
        this.geometryTotal = geometryTotal;
        this.geometryOptions = geometryOptions;
        this.geometryType = geometryType;
    }

    public abstract void writeToStream(ChunkOutputStream var1) throws IOException;

    public void freeze(int index) {
        this.index = index;
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isEmpty() {
        return this.geometryTotal == 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getGeometryTotal() {
        return this.geometryTotal;
    }

    public int getGeometryOptions() {
        return this.geometryOptions;
    }

    public ISkinGeometryType getGeometryType() {
        return this.geometryType;
    }

    public static class Mutable
    extends ChunkGeometrySection {
        private final ChunkDataOutputStream outputStream;

        public Mutable(int options, ISkinGeometryType geometryType, ChunkContext context) {
            super(0, options, geometryType);
            this.outputStream = new ChunkDataOutputStream(context);
        }

        public void write(ChunkGeometrySerializer.Encoder<?> encoder, ChunkPaletteData palette) throws IOException {
            encoder.end(palette, this.outputStream);
            ++this.geometryTotal;
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            this.outputStream.transferTo(stream.getOutputStream());
        }
    }

    public static class Immutable
    extends ChunkGeometrySection {
        public final int stride;
        private final byte[] bytes;
        private final ChunkPaletteData palette;

        public Immutable(int geometryTotal, int options, ISkinGeometryType geometryType, ChunkPaletteData palette) {
            super(geometryTotal, options, geometryType);
            this.stride = ChunkGeometrySerializers.getStride(geometryType, options, palette);
            this.bytes = new byte[this.stride * geometryTotal];
            this.palette = palette;
        }

        public void readFromStream(ChunkInputStream stream) throws IOException {
            stream.read(this.bytes);
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            stream.write(this.bytes);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public ChunkPaletteData getPalette() {
            return this.palette;
        }
    }
}

