/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCondition;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkConditionResult;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFile;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;

public class ChunkFileData
implements ChunkVariable,
ChunkCondition {
    public static final ChunkFileData EMPTY = new ChunkFileData();
    private final List<BooleanSupplier> dependencies = new ArrayList<BooleanSupplier>();
    private final List<ChunkFile> contents = new ArrayList<ChunkFile>();

    public ChunkFile readItem(ChunkInputStream stream) throws IOException {
        if (stream.getFileVersion() < 22) {
            int size = stream.readInt();
            ByteBuf buffer = stream.readBytes(size);
            return ChunkFile.image(null, buffer);
        }
        int id = stream.readVarInt();
        return this.contents.get(id);
    }

    public void writeItem(ChunkFile item, ChunkOutputStream stream) throws IOException {
        int id = this.contents.size();
        this.contents.add(item);
        stream.writeVarInt(id);
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        int size = stream.readVarInt();
        for (int i = 0; i < size; ++i) {
            int type = stream.readVarInt();
            Optional<String> name = stream.readOptionalString();
            SkinProperties properties = stream.readSkinProperties();
            int byteSize = stream.readVarInt();
            ByteBuf bytes = stream.readBytes(byteSize);
            this.contents.add(new ChunkFile(type, name.orElse(null), properties, bytes));
        }
    }

    @Override
    public void writeToStream(ChunkOutputStream stream) throws IOException {
        stream.writeVarInt(this.contents.size());
        for (ChunkFile content : this.contents) {
            stream.writeVarInt(content.getType());
            stream.writeOptionalString(content.getName());
            stream.writeSkinProperties(content.getProperties());
            ByteBuf buf = content.getBytes().slice();
            stream.writeVarInt(buf.readableBytes());
            stream.writeBytes(buf);
        }
    }

    @Override
    public boolean freeze() {
        for (BooleanSupplier dependency : this.dependencies) {
            if (dependency.getAsBoolean()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChunkFileData)) {
            return false;
        }
        ChunkFileData that = (ChunkFileData)o;
        return this.contents.equals(that.contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    @Override
    public ChunkConditionResult getResult() {
        if (!this.freeze()) {
            return ChunkConditionResult.PENDING;
        }
        if (this.contents.isEmpty()) {
            return ChunkConditionResult.FAILURE;
        }
        return ChunkConditionResult.PASS;
    }

    public void addDependency(BooleanSupplier dependency) {
        this.dependencies.add(dependency);
    }
}

