/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFileData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlag;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class ChunkContext {
    private static final List<ChunkType> ENCRYPTED_CHUNK_TYPES = Collections.immutableList(builder -> builder.add((Object)ChunkType.SKIN_PART));
    private static final List<ChunkType> COMPRESSED_CHUNK_TYPES = Collections.immutableList(builder -> {
        builder.add((Object)ChunkType.GEOMETRY_DATA);
        builder.add((Object)ChunkType.PAINT_DATA);
        builder.add((Object)ChunkType.PREVIEW_DATA);
        builder.add((Object)ChunkType.ANIMATION_DATA);
        builder.add((Object)ChunkType.PALETTE_DATA);
        builder.add((Object)ChunkType.SKIN_PART);
    });
    private boolean enablePartData = true;
    private boolean enablePreviewData = false;
    private boolean enableFastEncoder = true;
    private byte[] securityKey = null;
    private final ChunkFileData fileProvider = new ChunkFileData();
    private final ChunkPaletteData paletteProvider = new ChunkPaletteData(this.fileProvider);
    private final SkinFileOptions options;

    public ChunkContext(SkinFileOptions options) {
        this.options = options;
        try {
            this.setupWithOptions(options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupWithOptions(SkinFileOptions options) throws Exception {
        if (options.getSecurityData() != null && options.getSecurityKey() != null) {
            this.securityKey = Objects.decodeHex(options.getSecurityKey().toCharArray());
        }
    }

    public InputStream createInputStream(ByteBuf buf, ChunkFlags flags) throws IOException {
        Object inputStream = new ByteBufInputStream(buf);
        if (flags.contains(ChunkFlag.ENCRYPT)) {
            if (this.securityKey == null || this.securityKey.length == 0) {
                throw new IOException("missing security key!!");
            }
            try {
                SecretKeySpec key = new SecretKeySpec(this.securityKey, "AES");
                Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                aes.init(2, key);
                inputStream = new CipherInputStream((InputStream)inputStream, aes);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (flags.contains(ChunkFlag.GZIP)) {
            inputStream = new GZIPInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    public OutputStream createOutputStream(ByteBuf buf, ChunkFlags flags) throws IOException {
        Object outputStream = new ByteBufOutputStream(buf);
        if (flags.contains(ChunkFlag.ENCRYPT)) {
            if (this.securityKey == null || this.securityKey.length == 0) {
                throw new IOException("missing security key!!");
            }
            try {
                SecretKeySpec key = new SecretKeySpec(this.securityKey, "AES");
                Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                aes.init(1, key);
                outputStream = new CipherOutputStream((OutputStream)outputStream, aes);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        if (flags.contains(ChunkFlag.GZIP)) {
            outputStream = new GZIPOutputStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    public <V, T> ChunkFlags createSerializerFlags(ChunkSerializer<V, T> serializer, V value) {
        ChunkFlags flags = new ChunkFlags();
        if (this.options.isCompressed() && COMPRESSED_CHUNK_TYPES.contains((Object)serializer.getChunkType())) {
            flags.add(ChunkFlag.GZIP);
        }
        if (this.securityKey != null && ENCRYPTED_CHUNK_TYPES.contains((Object)serializer.getChunkType())) {
            flags.add(ChunkFlag.ENCRYPT);
        }
        return flags;
    }

    public boolean isEnablePartData() {
        return this.enablePartData;
    }

    public boolean isEnablePreviewData() {
        return this.enablePreviewData;
    }

    public void setFastEncoder(boolean enableFastEncoder) {
        this.enableFastEncoder = enableFastEncoder;
    }

    public boolean isEnableFastEncoder() {
        return this.enableFastEncoder;
    }

    public int getFileVersion() {
        return this.options.getFileVersion();
    }

    public String getSecurityData() {
        return this.options.getSecurityData();
    }

    public String getSecurityKey() {
        return this.options.getSecurityKey();
    }

    public ChunkFileData getFileProvider() {
        return this.fileProvider;
    }

    public ChunkPaletteData getPaletteProvider() {
        return this.paletteProvider;
    }

    public SkinFileOptions getOptions() {
        return this.options;
    }
}

