/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTextureData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.utils.Collections;

public abstract class ChunkColorSection {
    protected int index = 0;
    protected int size = 0;
    protected int colorIndexBytes = 1;
    protected int textureIndexBytes = 4;
    protected boolean resolved = false;
    protected final int usedBytes;
    protected final SkinPaintType paintType;

    public ChunkColorSection(int count, int colorBytes, SkinPaintType paintType) {
        this.size = count;
        this.usedBytes = colorBytes;
        this.paintType = paintType;
    }

    public abstract void writeToStream(ChunkOutputStream var1) throws IOException;

    public void freeze(int index) {
        this.index = index;
        this.resolved = true;
    }

    public void freezeIndex(int colorUsedIndex, int textureUsedIndex) {
        this.colorIndexBytes = colorUsedIndex;
        this.textureIndexBytes = textureUsedIndex;
    }

    public abstract SkinPaintColor getColor(int var1);

    public ChunkTextureData.TextureRef getTexture(OpenVector2f pos) {
        ChunkTextureData list = this.getTextureList(pos);
        if (list != null) {
            return list.get(pos, this);
        }
        return null;
    }

    protected abstract ChunkTextureData getTextureList(OpenVector2f var1);

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isTexture() {
        return this.usedBytes == 0;
    }

    public int getStartIndex() {
        return this.index;
    }

    public int getEndIndex() {
        return this.index + this.size;
    }

    public int getSize() {
        return this.size;
    }

    public int getUsedBytes() {
        return this.usedBytes;
    }

    public SkinPaintType getPaintType() {
        return this.paintType;
    }

    public static class ColorRef
    implements ChunkVariable {
        private final int value;
        private final ChunkColorSection section;

        public ColorRef(ChunkColorSection section, int value) {
            this.value = value;
            this.section = section;
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            stream.writeFixedInt(this.section.getStartIndex() + this.value, this.section.colorIndexBytes);
        }

        @Override
        public boolean freeze() {
            return this.section.isResolved();
        }
    }

    public static class Mutable
    extends ChunkColorSection {
        private final ArrayList<Integer> colorLists = new ArrayList();
        private final LinkedHashMap<Integer, ColorRef> indexes = new LinkedHashMap();
        private final LinkedHashMap<SkinTextureData, ChunkTextureData> textureLists = new LinkedHashMap();

        public Mutable(int colorBytes, SkinPaintType paintType) {
            super(0, colorBytes, paintType);
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            Iterator<Object> iterator = this.colorLists.iterator();
            while (iterator.hasNext()) {
                int color = iterator.next();
                stream.writeFixedInt(color, this.usedBytes);
            }
            for (ChunkTextureData list : this.textureLists.values()) {
                list.writeToStream(stream);
            }
        }

        @Override
        public void freeze(int index) {
            if (!this.textureLists.isEmpty()) {
                float x = 0.0f;
                float y = 0.0f;
                float lineHeight = 0.0f;
                ArrayList<ChunkTextureData> lists = new ArrayList<ChunkTextureData>(this.textureLists.values());
                int columns = OpenMath.ceili(Math.sqrt(lists.size()));
                int col = 0;
                for (int i = 0; i < lists.size(); ++i) {
                    ChunkTextureData list = lists.get(i);
                    list.freeze(x, y, this.textureLists::get);
                    OpenRectangle2f usedRect = list.getUsedRect();
                    lineHeight = Math.max(lineHeight, usedRect.height());
                    x += usedRect.width() + 16.0f;
                    if (++col < columns) continue;
                    y += lineHeight + 16.0f;
                    x = 0.0f;
                    lineHeight = 0.0f;
                    col = 0;
                }
            }
            this.size = this.colorLists.size() + this.textureLists.size();
            super.freeze(index);
        }

        @Override
        public SkinPaintColor getColor(int offset) {
            int value = this.colorLists.get(offset);
            return SkinPaintColor.of(value, this.getPaintType());
        }

        public ColorRef putColor(int value) {
            if (this.usedBytes == 3) {
                value |= 0xFF000000;
            }
            return this.indexes.computeIfAbsent(value, k -> {
                ColorRef ref = new ColorRef(this, this.colorLists.size());
                this.colorLists.add((Integer)k);
                return ref;
            });
        }

        public ChunkTextureData.TextureRef putTexture(OpenVector2f uv, SkinTextureData provider) {
            ChunkTextureData textureList = this.getOrCreateTextureList(provider);
            Collections.eachTree(provider.getVariants(), SkinTextureData::getVariants, this::getOrCreateTextureList);
            return textureList.add(uv, this);
        }

        public ChunkTextureData.OptionsRef putTextureOptions(SkinTextureOptions options) {
            return new ChunkTextureData.OptionsRef(this, options);
        }

        @Override
        protected ChunkTextureData getTextureList(OpenVector2f pos) {
            for (ChunkTextureData list : this.textureLists.values()) {
                if (!list.contains(pos)) continue;
                return list;
            }
            return null;
        }

        protected ChunkTextureData getOrCreateTextureList(SkinTextureData provider) {
            return this.textureLists.computeIfAbsent(provider, it -> {
                ChunkTextureData list = new ChunkTextureData((SkinTextureData)it);
                list.setId(this.textureLists.size() + 1);
                return list;
            });
        }
    }

    public static class Immutable
    extends ChunkColorSection {
        private byte[] buffers;
        private ChunkTextureData[] textureLists;

        public Immutable(int total, int usedBytes, SkinPaintType paintType) {
            super(total, usedBytes, paintType);
        }

        public void readFromStream(ChunkInputStream stream) throws IOException {
            if (this.usedBytes != 0) {
                this.buffers = new byte[this.usedBytes * this.size];
                stream.read(this.buffers);
            }
            if (this.isTexture()) {
                this.textureLists = new ChunkTextureData[this.size];
                for (int i = 0; i < this.size; ++i) {
                    ChunkTextureData list = new ChunkTextureData();
                    list.readFromStream(stream);
                    this.textureLists[i] = list;
                }
                for (ChunkTextureData parent : this.textureLists) {
                    ArrayList<SkinTextureData> variants = new ArrayList<SkinTextureData>(parent.provider.getVariants());
                    for (ChunkTextureData child : this.textureLists) {
                        if (parent.id != child.parentId) continue;
                        variants.add(child.provider);
                    }
                    parent.provider.setVariants(variants);
                }
            }
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            if (this.buffers != null) {
                stream.write(this.buffers);
            }
            if (this.textureLists != null) {
                for (ChunkTextureData list : this.textureLists) {
                    list.writeToStream(stream);
                }
            }
        }

        @Override
        public SkinPaintColor getColor(int offset) {
            int value = 0;
            for (int i = 0; i < this.usedBytes; ++i) {
                value = value << 8 | this.buffers[offset * this.usedBytes + i] & 0xFF;
            }
            return SkinPaintColor.of(value, this.getPaintType());
        }

        @Override
        public ChunkTextureData getTextureList(OpenVector2f pos) {
            if (this.textureLists == null) {
                return null;
            }
            for (ChunkTextureData list : this.textureLists) {
                if (!list.contains(pos)) continue;
                return list;
            }
            return null;
        }
    }
}

