/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializers;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializers;
import org.apache.commons.lang3.tuple.Pair;

public final class SkinSerializerV20
implements IOSerializer {
    public static final int FILE_MIN_VERSION = 20;
    public static final int FILE_LATEST_VERSION = 25;

    @Override
    public void writeToStream(Skin skin, IOutputStream stream, SkinFileOptions options) throws IOException {
        stream.writeInt(0);
        stream.writeInt(0);
        ChunkContext context = ChunkGeometrySerializers.createEncodeContext(skin, options);
        ChunkSerializers.writeToStream(skin, stream, context);
        stream.writeInt(0);
    }

    @Override
    public Skin readFromStream(IInputStream stream, SkinFileOptions options) throws IOException {
        stream.readInt();
        stream.readInt();
        ChunkContext context = ChunkGeometrySerializers.createDecodeContext(options);
        return ChunkSerializers.readFromStream(stream, context);
    }

    @Override
    public SkinFileHeader readInfoFromStream(IInputStream stream, SkinFileOptions options) throws IOException {
        stream.readInt();
        stream.readInt();
        ChunkContext context = ChunkGeometrySerializers.createDecodeContext(options);
        Pair<SkinType, SkinProperties> pair = ChunkSerializers.readInfoFromStream(stream, context);
        return SkinFileHeader.optimized(options.getFileVersion(), (SkinType)pair.getKey(), (SkinProperties)pair.getValue());
    }

    @Override
    public boolean isSupportedVersion(SkinFileOptions options) {
        return options.getFileVersion() >= 20;
    }

    @Override
    public int getVersion() {
        return 25;
    }

    @Override
    public boolean isRequiresHeader() {
        return true;
    }
}

