/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinPreviewData;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkAnimationData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFileData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometryData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaintData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPartData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPreviewData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkSerializers {
    public static final ChunkSerializer<Skin, Void> SKIN = ChunkSerializers.register(new ChunkSerializer<Skin, Void>(ChunkType.SKIN, null){

        @Override
        public Skin read(ChunkDataInputStream stream, Void obj) throws IOException {
            ChunkContext context = stream.getContext();
            SkinType skinType = stream.readType(SkinTypes::byName);
            return stream.readChunk(it -> {
                SkinSettings settings = it.read(SKIN_SETTINGS);
                if (settings.getSecurityData() != null && !settings.getSecurityData().equals(context.getSecurityData())) {
                    throw new IOException("Can't decrypt skin by the security key.");
                }
                ChunkFileData fileData = it.read(SKIN_FILE_DATA);
                ChunkPaletteData paletteData = it.read(SKIN_PALETTE_DATA);
                ChunkGeometryData geometryData = it.read(SKIN_GEOMETRY_DATA);
                Skin.Builder builder = new Skin.Builder(skinType);
                builder.properties(it.read(SKIN_PROPERTIES));
                builder.settings(settings);
                builder.paintData(it.read(SKIN_PAINT_DATA));
                builder.previewData(it.read(SKIN_PREVIEW_DATA, geometryData));
                builder.parts(it.read(SKIN_PART, geometryData));
                builder.animations(it.read(SKIN_ANIMATION_DATA));
                builder.blobs(it.readBlobs());
                builder.id(geometryData.getId());
                builder.version(context.getFileVersion());
                return builder.build();
            });
        }

        @Override
        public void write(Skin skin, Void obj, ChunkDataOutputStream stream) throws IOException {
            ChunkContext context = stream.getContext();
            stream.writeType(skin.getType());
            stream.writeChunk(it -> {
                ChunkFileData fileData = context.getFileProvider();
                ChunkPaletteData paletteData = context.getPaletteProvider();
                ChunkGeometryData geometryData = new ChunkGeometryData(skin.getId(), paletteData);
                it.write(SKIN_PROPERTIES, skin.getProperties());
                it.write(SKIN_SETTINGS, skin.getSettings().copyWithOptions(context.getOptions()));
                it.write(SKIN_PALETTE_DATA, paletteData);
                it.write(SKIN_PAINT_DATA, skin.getPaintData());
                it.write(SKIN_GEOMETRY_DATA, geometryData);
                it.write(SKIN_ANIMATION_DATA, skin.getAnimations());
                it.write(SKIN_PART, skin.getParts(), geometryData);
                it.write(SKIN_FILE_DATA, fileData);
                if (context.isEnablePreviewData()) {
                    it.write(SKIN_PREVIEW_DATA, SkinPreviewData.of(skin), geometryData);
                }
                it.writeBlobs(skin.getBlobs());
            });
        }
    });
    public static final ChunkSerializer<Pair<SkinType, SkinProperties>, Void> SKIN_INFO = ChunkSerializers.register(new ChunkSerializer<Pair<SkinType, SkinProperties>, Void>(ChunkType.SKIN, null){

        @Override
        public Pair<SkinType, SkinProperties> read(ChunkDataInputStream stream, Void obj) throws IOException {
            SkinType skinType = stream.readType(SkinTypes::byName);
            return stream.readChunk(it -> {
                SkinProperties properties = it.read(SKIN_PROPERTIES);
                SkinSettings settings = it.read(SKIN_SETTINGS);
                if (settings.getSecurityData() != null) {
                    properties = properties.copy();
                    properties.put(SkinProperty.SECURITY_DATA, settings.getSecurityData());
                }
                return Pair.of((Object)skinType, (Object)properties);
            });
        }

        @Override
        public void write(Pair<SkinType, SkinProperties> info, Void obj, ChunkDataOutputStream stream) throws IOException {
        }
    });
    public static final ChunkSerializer<List<SkinPart>, ChunkGeometryData> SKIN_PART = ChunkSerializers.register(new ChunkSerializer<List<SkinPart>, ChunkGeometryData>(ChunkType.SKIN_PART, null){

        @Override
        public List<SkinPart> read(ChunkDataInputStream stream, ChunkGeometryData geometryData) throws IOException {
            ChunkPartData partData = new ChunkPartData(geometryData);
            return partData.readFromStream(stream, (it, builder) -> {
                builder.markers(it.read(SKIN_MARKERS));
                builder.properties(it.read(SKIN_PROPERTIES));
                builder.blobs(it.readBlobs());
            });
        }

        @Override
        public void write(List<SkinPart> parts, ChunkGeometryData geometryData, ChunkDataOutputStream stream) throws IOException {
            ChunkPartData partData = new ChunkPartData(geometryData);
            partData.writeToStream(stream, parts, (it, part) -> {
                SkinProperties properties = part.getProperties();
                if (properties instanceof SkinProperties.Stub) {
                    properties = SkinProperties.EMPTY;
                }
                it.write(SKIN_MARKERS, part.getMarkers());
                it.write(SKIN_PROPERTIES, properties);
                it.writeBlobs(part.getBlobs());
            });
        }
    });
    public static final ChunkSerializer<List<SkinMarker>, Void> SKIN_MARKERS = ChunkSerializers.register(new ChunkSerializer<List<SkinMarker>, Void>(ChunkType.MARKER, null){

        @Override
        public List<SkinMarker> read(ChunkDataInputStream stream, Void obj) throws IOException {
            int size = stream.readInt();
            ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
            for (int i = 0; i < size; ++i) {
                markers.add(new SkinMarker(stream));
            }
            return markers;
        }

        @Override
        public void write(List<SkinMarker> value, Void obj, ChunkDataOutputStream stream) throws IOException {
            stream.writeInt(value.size());
            for (SkinMarker marker : value) {
                marker.writeToStream(stream);
            }
        }
    });
    public static final ChunkSerializer<ChunkGeometryData, Void> SKIN_GEOMETRY_DATA = ChunkSerializers.register(new ChunkSerializer<ChunkGeometryData, Void>(ChunkType.GEOMETRY_DATA, null){

        @Override
        public ChunkGeometryData read(ChunkDataInputStream stream, Void obj) throws IOException {
            ChunkPaletteData palette = stream.getPaletteProvider();
            ChunkGeometryData geometryData = new ChunkGeometryData(Skin.Builder.generateId(), palette);
            geometryData.readFromStream(stream);
            return geometryData;
        }

        @Override
        public void write(ChunkGeometryData geometryData, Void obj, ChunkDataOutputStream stream) throws IOException {
            stream.writeVariable(geometryData);
        }
    });
    public static final ChunkSerializer<SkinPaintData, Void> SKIN_PAINT_DATA = ChunkSerializers.register(new ChunkSerializer<SkinPaintData, Void>(ChunkType.PAINT_DATA, null){

        @Override
        public SkinPaintData read(ChunkDataInputStream stream, Void obj) throws IOException {
            ChunkPaintData chunkPaintData = new ChunkPaintData();
            return chunkPaintData.readFromStream(stream);
        }

        @Override
        public void write(SkinPaintData value, Void obj, ChunkDataOutputStream stream) throws IOException {
            ChunkPaintData chunkPaintData = new ChunkPaintData();
            chunkPaintData.writeToStream(value, stream);
        }
    });
    public static final ChunkSerializer<SkinPreviewData, ChunkGeometryData> SKIN_PREVIEW_DATA = ChunkSerializers.register(new ChunkSerializer<SkinPreviewData, ChunkGeometryData>(ChunkType.PREVIEW_DATA, null){

        @Override
        public SkinPreviewData read(ChunkDataInputStream stream, ChunkGeometryData geometryData) throws IOException {
            ChunkPreviewData chunkPreviewData = new ChunkPreviewData(geometryData);
            return chunkPreviewData.readFromStream(stream);
        }

        @Override
        public void write(SkinPreviewData previewData, ChunkGeometryData geometryData, ChunkDataOutputStream stream) throws IOException {
            ChunkPreviewData chunkPreviewData = new ChunkPreviewData(geometryData);
            chunkPreviewData.writeToStream(previewData, stream);
        }
    });
    public static final ChunkSerializer<ChunkPaletteData, Void> SKIN_PALETTE_DATA = ChunkSerializers.register(new ChunkSerializer<ChunkPaletteData, Void>(ChunkType.PALETTE_DATA, null){

        @Override
        public ChunkPaletteData read(ChunkDataInputStream stream, Void file) throws IOException {
            ChunkPaletteData palette = stream.getPaletteProvider();
            palette.readFromStream(stream);
            return palette;
        }

        @Override
        public void write(ChunkPaletteData value, Void obj, ChunkDataOutputStream stream) throws IOException {
            stream.writeVariable(value);
        }
    });
    public static final ChunkSerializer<List<SkinAnimation>, Void> SKIN_ANIMATION_DATA = ChunkSerializers.register(new ChunkSerializer<List<SkinAnimation>, Void>(ChunkType.ANIMATION_DATA, null){

        @Override
        public List<SkinAnimation> read(ChunkDataInputStream stream, Void obj) throws IOException {
            ChunkAnimationData animationData = new ChunkAnimationData(new ArrayList<SkinAnimation>());
            animationData.readFromStream(stream);
            return animationData.getAnimations();
        }

        @Override
        public void write(List<SkinAnimation> value, Void obj, ChunkDataOutputStream stream) throws IOException {
            ChunkAnimationData animationData = new ChunkAnimationData(value);
            animationData.writeToStream(stream);
        }
    });
    public static final ChunkSerializer<ChunkFileData, Void> SKIN_FILE_DATA = ChunkSerializers.register(new ChunkSerializer<ChunkFileData, Void>(ChunkType.FILE_DATA, ChunkFileData.EMPTY){

        @Override
        public ChunkFileData read(ChunkDataInputStream stream, Void obj) throws IOException {
            ChunkFileData file = stream.getFileProvider();
            file.readFromStream(stream);
            return file;
        }

        @Override
        public void write(ChunkFileData value, Void obj, ChunkDataOutputStream stream) throws IOException {
            stream.writeVariable(value);
        }
    });
    public static final ChunkSerializer<SkinProperties, Void> SKIN_PROPERTIES = ChunkSerializers.register(new ChunkSerializer<SkinProperties, Void>(ChunkType.PROPERTIES, SkinProperties.EMPTY){

        @Override
        public SkinProperties read(ChunkDataInputStream stream, Void obj) throws IOException {
            SkinProperties properties = new SkinProperties();
            properties.readFromStream(stream);
            return properties;
        }

        @Override
        public void write(SkinProperties value, Void obj, ChunkDataOutputStream stream) throws IOException {
            value.writeToStream(stream);
        }
    });
    public static final ChunkSerializer<SkinSettings, Void> SKIN_SETTINGS = ChunkSerializers.register(new ChunkSerializer<SkinSettings, Void>(ChunkType.SKIN_SETTINGS, SkinSettings.EMPTY){

        @Override
        public void config() {
            this.decoders.put("SET2", (stream, obj) -> {
                OpenItemTransforms itemTransforms = null;
                int size1 = stream.readVarInt();
                if (size1 != 0) {
                    itemTransforms = new OpenItemTransforms();
                    for (int i = 1; i < size1; ++i) {
                        String name = stream.readString();
                        OpenVector3f translate = stream.readVector3f();
                        OpenVector3f rotation = stream.readVector3f();
                        OpenVector3f scale = stream.readVector3f();
                        itemTransforms.put(name, OpenTransform3f.create(translate, rotation, scale));
                    }
                }
                boolean isEditable = stream.readBoolean();
                SkinSettings settings = new SkinSettings();
                settings.setEditable(isEditable);
                settings.setItemTransforms(itemTransforms);
                return settings;
            });
            this.decoders.put("SET3", (stream, obj) -> {
                OpenItemTransforms itemTransforms = null;
                int dataVersion = stream.readVarInt();
                int size1 = stream.readVarInt();
                if (size1 != 0) {
                    itemTransforms = new OpenItemTransforms();
                    for (int i = 1; i < size1; ++i) {
                        String name = stream.readString();
                        OpenVector3f translate = stream.readVector3f();
                        OpenVector3f rotation = stream.readVector3f();
                        OpenVector3f scale = stream.readVector3f();
                        itemTransforms.put(name, OpenTransform3f.create(translate, rotation, scale));
                    }
                }
                ArrayList<OpenRectangle3f> collisionBox = null;
                int size2 = stream.readVarInt();
                if (size2 != 0) {
                    collisionBox = new ArrayList<OpenRectangle3f>();
                    for (int i = 1; i < size2; ++i) {
                        OpenRectangle3f rect = new OpenRectangle3f(stream.readRectangle3i());
                        collisionBox.add(rect);
                    }
                }
                boolean isEditable = stream.readBoolean();
                SkinSettings settings = new SkinSettings();
                settings.setEditable(isEditable);
                settings.setItemTransforms(itemTransforms);
                settings.setCollisionBox(collisionBox);
                return settings;
            });
        }

        @Override
        public SkinSettings read(ChunkDataInputStream stream, Void obj) throws IOException {
            SkinSettings settings = new SkinSettings();
            settings.readFromStream(stream);
            return settings;
        }

        @Override
        public void write(SkinSettings value, Void obj, ChunkDataOutputStream stream) throws IOException {
            value.writeToStream(stream);
        }
    });

    public static void writeToStream(Skin skin, IOutputStream stream, ChunkContext context) throws IOException {
        ChunkDataOutputStream stream1 = new ChunkDataOutputStream(context);
        SKIN.write(skin, null, stream1);
        stream1.transferTo(stream.getOutputStream());
    }

    public static Skin readFromStream(IInputStream stream, ChunkContext context) throws IOException {
        ChunkDataInputStream stream1 = new ChunkDataInputStream(stream.getInputStream(), context, null);
        return SKIN.read(stream1, null);
    }

    public static Pair<SkinType, SkinProperties> readInfoFromStream(IInputStream stream, ChunkContext context) throws IOException {
        ArrayList<String> allows = Collections.newList(ChunkType.PROPERTIES.getName(), ChunkType.SKIN_SETTINGS.getName());
        ChunkDataInputStream stream1 = new ChunkDataInputStream(stream.getInputStream(), context, allows::contains);
        return SKIN_INFO.read(stream1, null);
    }

    private static <T, C> ChunkSerializer<T, C> register(ChunkSerializer<T, C> serializer) {
        return serializer;
    }
}

