/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkType;

public abstract class ChunkSerializer<V, C> {
    protected final ChunkType chunkType;
    protected final Map<String, Decoder<V, C>> decoders = new LinkedHashMap<String, Decoder<V, C>>();
    protected final V defaultValue;

    public ChunkSerializer(ChunkType chunkType, V defaultValue) {
        this.chunkType = chunkType;
        this.defaultValue = defaultValue;
        this.decoders.put(chunkType.getName(), this::read);
        this.config();
    }

    protected void config() {
    }

    public abstract V read(ChunkDataInputStream var1, C var2) throws IOException;

    public abstract void write(V var1, C var2, ChunkDataOutputStream var3) throws IOException;

    public ChunkFlags getChunkFlags(V value, ChunkContext context) {
        return context.createSerializerFlags(this, value);
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public Decoder<V, C> createDecoder(String name) {
        return this.decoders.get(name);
    }

    public Encoder<V, C> createEncoder(V value, C obj, ChunkContext context) {
        return this::write;
    }

    public static interface Decoder<V, C> {
        public V decode(ChunkDataInputStream var1, C var2) throws IOException;
    }

    public static interface Encoder<V, C> {
        public void encode(V var1, C var2, ChunkDataOutputStream var3) throws IOException;
    }
}

