/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v13;

import java.io.IOException;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.geometry.collection.SkinGeometrySetV1;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.init.ModLog;

public final class SkinPartSerializerV13 {
    public SkinPart loadSkinPart(IInputStream stream, int version) throws IOException, InvalidCubeTypeException {
        SkinPartType partType;
        String regName = stream.readString();
        if (regName.equals("armourers:skirt.base")) {
            regName = "armourers:legs.skirt";
        }
        if (regName.equals("armourers:bow.base")) {
            regName = "armourers:bow.frame1";
        }
        if (regName.equals("armourers:arrow.base")) {
            regName = "armourers:bow.arrow";
        }
        if ((partType = SkinPartTypes.byName(regName)) == null) {
            ModLog.error("Skin part was null - reg name: " + regName + " version: " + version, new Object[0]);
            throw new IOException("Skin part was null - reg name: " + regName + " version: " + version);
        }
        SkinGeometrySetV1 geometries = SkinGeometrySetV1.readFromStream(stream, version, partType);
        ArrayList<SkinMarker> markerBlocks = new ArrayList<SkinMarker>();
        int markerCount = stream.readInt();
        for (int i = 0; i < markerCount; ++i) {
            markerBlocks.add(new SkinMarker(stream));
        }
        SkinPart.Builder builder = new SkinPart.Builder(partType);
        builder.markers(markerBlocks);
        builder.geometries(geometries);
        return builder.build();
    }

    public void saveSkinPart(SkinPart skinPart, IOutputStream stream) throws IOException {
        stream.writeString(skinPart.getType().getRegistryName().toString());
        SkinGeometrySetV1.writeToStream(skinPart.getGeometries(), stream);
        stream.writeInt(skinPart.getMarkers().size());
        for (SkinMarker marker : skinPart.getMarkers()) {
            marker.writeToStream(stream);
        }
    }
}

