/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.io;

import io.netty.buffer.ByteBuf;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.api.core.IRegistryEntry;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.core.math.ITransform3f;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.api.core.math.IVector3i;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import net.minecraft.nbt.CompoundTag;

public interface IOutputStream {
    public static IOutputStream of(OutputStream stream) {
        if (stream instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)stream;
            return IOutputStream.of(dataOutputStream);
        }
        return IOutputStream.of(new DataOutputStream(stream));
    }

    public static IOutputStream of(DataOutputStream stream) {
        return () -> stream;
    }

    public DataOutputStream getOutputStream();

    default public void write(byte[] bytes) throws IOException {
        this.getOutputStream().write(bytes);
    }

    default public void write(byte[] b, int off, int len) throws IOException {
        this.getOutputStream().write(b, off, len);
    }

    default public void writeBytes(ByteBuf buf) throws IOException {
        this.writeBytes(buf, buf.readableBytes());
    }

    default public void writeBytes(ByteBuf buf, int limit) throws IOException {
        buf.getBytes(0, (OutputStream)this.getOutputStream(), limit);
    }

    default public void writeByte(int v) throws IOException {
        this.getOutputStream().writeByte(v);
    }

    default public void writeBoolean(boolean v) throws IOException {
        this.getOutputStream().writeBoolean(v);
    }

    default public void writeShort(int v) throws IOException {
        this.getOutputStream().writeShort(v);
    }

    default public void writeInt(int v) throws IOException {
        this.getOutputStream().writeInt(v);
    }

    default public void writeLong(long v) throws IOException {
        this.getOutputStream().writeLong(v);
    }

    default public void writeFloat(float v) throws IOException {
        this.getOutputStream().writeFloat(v);
    }

    default public void writeDouble(double v) throws IOException {
        this.getOutputStream().writeDouble(v);
    }

    default public void writeFixedInt(int value, int usedBytes) throws IOException {
        if (usedBytes == 4) {
            this.writeInt(value);
            return;
        }
        for (int i = usedBytes; i > 0; --i) {
            int ch = value >> (i - 1) * 8;
            this.writeByte(ch & 0xFF);
        }
    }

    default public void writeFixedFloat(float value, int usedBytes) throws IOException {
        this.writeFixedInt(Float.floatToIntBits(value), usedBytes);
    }

    default public void writeString(String v) throws IOException {
        if (v == null || v.isEmpty()) {
            this.getOutputStream().writeShort(0);
            return;
        }
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        int size = bytes.length;
        if (size > 65535) {
            throw new IOException("String is over the max length allowed.");
        }
        this.getOutputStream().writeShort((short)size);
        this.getOutputStream().write(bytes);
    }

    default public void writeString(String v, int len) throws IOException {
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        this.getOutputStream().write(bytes, 0, len);
    }

    default public void writeVarInt(int i) throws IOException {
        DataOutputStream outputStream = this.getOutputStream();
        while (true) {
            if ((i & 0xFFFFFF80) == 0) break;
            outputStream.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        outputStream.writeByte(i);
    }

    default public void writeFloatArray(float[] values) throws IOException {
        for (float value : values) {
            this.writeFloat(value);
        }
    }

    default public void writeEnum(Enum<?> value) throws IOException {
        this.writeVarInt(value.ordinal());
    }

    default public void writePrimitiveObject(OpenPrimitive value) throws IOException {
        Integer integerValue;
        Object rawValue = value.rawValue();
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            int len = stringValue.length();
            this.writeVarInt(len + 8);
            this.writeString(stringValue, len);
        } else if (rawValue instanceof Double) {
            Double doubleValue = (Double)rawValue;
            this.writeVarInt(7);
            this.writeDouble(doubleValue);
        } else if (rawValue instanceof Float) {
            Float floatValue = (Float)rawValue;
            this.writeVarInt(6);
            this.writeFloat(floatValue.floatValue());
        } else if (rawValue instanceof Long) {
            Long longValue = (Long)rawValue;
            this.writeVarInt(5);
            this.writeLong(longValue);
        } else if (rawValue instanceof Integer && ((integerValue = (Integer)rawValue) & 0xFFFF0000) != 0) {
            this.writeVarInt(4);
            this.writeInt(integerValue);
        } else if (rawValue instanceof Number) {
            Number numberValue = (Number)rawValue;
            this.writeVarInt(3);
            this.writeVarInt(numberValue.intValue());
        } else if (rawValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)rawValue;
            if (booleanValue.booleanValue()) {
                this.writeVarInt(2);
            } else {
                this.writeVarInt(1);
            }
        } else if (rawValue == null) {
            this.writeVarInt(0);
        } else {
            throw new IOException("can't support primitive type: " + String.valueOf(rawValue.getClass()));
        }
    }

    default public void writeOptionalString(String v) throws IOException {
        if (v == null) {
            this.writeVarInt(0);
            return;
        }
        int len = v.length();
        this.writeVarInt(len + 1);
        this.writeString(v, len);
    }

    default public void writeVector3i(IVector3i vec) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeInt(vec.x());
        stream.writeInt(vec.y());
        stream.writeInt(vec.z());
    }

    default public void writeVector3f(IVector3f vec) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeFloat(vec.x());
        stream.writeFloat(vec.y());
        stream.writeFloat(vec.z());
    }

    default public void writeRectangle3i(IRectangle3i rect) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeInt(rect.x());
        stream.writeInt(rect.y());
        stream.writeInt(rect.z());
        stream.writeInt(rect.width());
        stream.writeInt(rect.height());
        stream.writeInt(rect.depth());
    }

    default public void writeRectangle3f(IRectangle3f rect) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeFloat(rect.x());
        stream.writeFloat(rect.y());
        stream.writeFloat(rect.z());
        stream.writeFloat(rect.width());
        stream.writeFloat(rect.height());
        stream.writeFloat(rect.depth());
    }

    default public void writeTransformf(ITransform3f transform) throws IOException {
        if (transform instanceof OpenTransform3f) {
            OpenTransform3f transform1 = (OpenTransform3f)transform;
            transform1.writeToStream(this);
        }
    }

    default public void writeSkinProperties(SkinProperties properties) throws IOException {
        properties.writeToStream(this);
    }

    default public void writeTextureAnimation(SkinTextureAnimation animation) throws IOException {
        animation.writeToStream(this);
    }

    default public void writeTextureProperties(SkinTextureProperties properties) throws IOException {
        properties.writeToStream(this);
    }

    default public void writeType(IRegistryEntry type) throws IOException {
        this.writeString(type.getRegistryName().toString());
    }

    default public void writeCompoundTag(CompoundTag value) throws IOException {
        TagSerializer.writeToStream(value, (OutputStream)this.getOutputStream());
    }
}

