/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenSize2f;
import moe.plushie.armourers_workshop.core.math.OpenSize3f;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchAnimation;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchDisplay;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchElement;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchObject;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchOutliner;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchTexture;
import org.jetbrains.annotations.Nullable;

public class BlockBenchPack {
    private final String name;
    private final String description;
    private final String version;
    private final String format;
    private final List<String> authors;
    private final OpenSize2f resolution;
    private final OpenSize3f visibleBox;
    private final BlockBenchOutliner rootOutliner;
    private final List<BlockBenchElement> elements;
    private final List<BlockBenchTexture> textures;
    private final List<BlockBenchAnimation> animations;
    private final Map<String, BlockBenchDisplay> transforms;
    private final Map<String, BlockBenchObject> objects = new HashMap<String, BlockBenchObject>();

    public BlockBenchPack(String name, String description, String version, String format, List<String> authors, OpenSize2f resolution, OpenSize3f visibleBox, BlockBenchOutliner rootOutliner, List<BlockBenchElement> elements, List<BlockBenchTexture> textures, List<BlockBenchAnimation> animations, Map<String, BlockBenchDisplay> transforms) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.format = format;
        this.authors = authors;
        this.resolution = resolution;
        this.visibleBox = visibleBox;
        this.elements = elements;
        this.rootOutliner = rootOutliner;
        this.textures = textures;
        this.animations = animations;
        this.transforms = transforms;
        elements.forEach(it -> this.objects.put(it.getUUID(), (BlockBenchObject)it));
        rootOutliner.getChildren().forEach(it -> {
            if (it instanceof BlockBenchObject) {
                BlockBenchObject object = (BlockBenchObject)it;
                this.objects.put(object.getUUID(), object);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFormat() {
        return this.format;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public OpenSize2f getResolution() {
        return this.resolution;
    }

    public OpenSize3f getVisibleBox() {
        return this.visibleBox;
    }

    public BlockBenchOutliner getRootOutliner() {
        return this.rootOutliner;
    }

    public List<BlockBenchElement> getElements() {
        return this.elements;
    }

    public List<BlockBenchTexture> getTextures() {
        return this.textures;
    }

    public List<BlockBenchAnimation> getAnimations() {
        return this.animations;
    }

    @Nullable
    public Map<String, BlockBenchDisplay> getItemTransforms() {
        return this.transforms;
    }

    @Nullable
    public BlockBenchObject getObject(String uuid) {
        return this.objects.get(uuid);
    }

    protected static class Builder {
        private String name;
        private String description;
        private String version = "4.10";
        private String format = "free";
        private List<String> authors;
        private OpenSize2f resolution = new OpenSize2f(64.0f, 64.0f);
        private OpenSize3f visibleBox = new OpenSize3f(8.0f, 7.0f, 1.5f);
        private boolean useItemTransforms = false;
        private final List<BlockBenchElement> elements = new ArrayList<BlockBenchElement>();
        private final List<BlockBenchTexture> textures = new ArrayList<BlockBenchTexture>();
        private final List<BlockBenchAnimation> animations = new ArrayList<BlockBenchAnimation>();
        private final Map<String, BlockBenchDisplay> transforms = new LinkedHashMap<String, BlockBenchDisplay>();
        private final BlockBenchOutliner.Builder rootOutliner = new BlockBenchOutliner.Builder();

        protected Builder() {
        }

        public void name(String name) {
            this.name = name;
        }

        public void description(String description) {
            this.description = description;
        }

        public void version(String version) {
            this.version = version;
        }

        public void format(String format) {
            this.format = format;
        }

        public void author(List<String> author) {
            this.authors = author;
        }

        public void resolution(OpenSize2f resolution) {
            this.resolution = resolution;
        }

        public void visibleBox(OpenSize3f visibleBox) {
            this.visibleBox = visibleBox;
        }

        public void setUseItemTransforms(boolean useItemTransforms) {
            this.useItemTransforms = useItemTransforms;
        }

        public void addElement(BlockBenchElement element) {
            this.elements.add(element);
        }

        public void addOutliner(Object obj) {
            this.rootOutliner.addChild(obj);
        }

        public void addTexture(BlockBenchTexture texture) {
            this.textures.add(texture);
        }

        public void addDisplay(String name, BlockBenchDisplay transform) {
            this.transforms.put(name, transform);
        }

        public void addAnimation(BlockBenchAnimation animation) {
            this.animations.add(animation);
        }

        public BlockBenchPack build() {
            Map<String, BlockBenchDisplay> itemTransforms = this.transforms;
            if (!this.useItemTransforms) {
                itemTransforms = null;
            }
            return new BlockBenchPack(this.name, this.description, this.version, this.format, this.authors, this.resolution, this.visibleBox, this.rootOutliner.build(), this.elements, this.textures, this.animations, itemTransforms);
        }
    }
}

