/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench;

import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchElement;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchMeshFace;

public class BlockBenchMesh
extends BlockBenchElement {
    private final boolean boxUV;
    private final boolean mirrorUV;
    private final boolean allowMirrorModeling;
    private final OpenVector2f uvOffset;
    private final OpenVector3f origin;
    private final OpenVector3f rotation;
    private final Map<String, BlockBenchMeshFace> faces;
    private final Map<String, OpenVector3f> vertices;

    public BlockBenchMesh(String uuid, String name, String type, boolean allowExport, boolean allowMirrorModeling, boolean boxUV, boolean mirrorUV, OpenVector2f uvOffset, OpenVector3f origin, OpenVector3f rotation, Map<String, BlockBenchMeshFace> faces, Map<String, OpenVector3f> vertices) {
        super(uuid, name, type, allowExport);
        this.origin = origin;
        this.rotation = rotation;
        this.boxUV = boxUV;
        this.mirrorUV = mirrorUV;
        this.allowMirrorModeling = allowMirrorModeling;
        this.uvOffset = uvOffset;
        this.faces = faces;
        this.vertices = vertices;
    }

    public OpenVector3f getOrigin() {
        return this.origin;
    }

    public OpenVector3f getRotation() {
        return this.rotation;
    }

    public boolean isBoxUV() {
        return this.boxUV;
    }

    public boolean isMirrorUV() {
        return this.mirrorUV;
    }

    public OpenVector2f getUVOffset() {
        return this.uvOffset;
    }

    public Map<String, BlockBenchMeshFace> getFaces() {
        return this.faces;
    }

    public Map<String, OpenVector3f> getVertices() {
        return this.vertices;
    }

    protected static class Builder
    extends BlockBenchElement.Builder {
        protected boolean boxUV = false;
        protected boolean mirrorUV = false;
        protected boolean allowMirrorModeling = false;
        protected OpenVector2f uvOffset = OpenVector2f.ZERO;
        protected OpenVector3f origin = OpenVector3f.ZERO;
        protected OpenVector3f rotation = OpenVector3f.ZERO;
        protected final Map<String, BlockBenchMeshFace> faces = new LinkedHashMap<String, BlockBenchMeshFace>();
        protected final Map<String, OpenVector3f> vertices = new LinkedHashMap<String, OpenVector3f>();

        protected Builder() {
        }

        public void boxUV(boolean boxUV) {
            this.boxUV = boxUV;
        }

        public void mirrorUV(boolean mirrorUV) {
            this.mirrorUV = mirrorUV;
        }

        public void allowMirrorModeling(boolean allowMirrorModeling) {
            this.allowMirrorModeling = allowMirrorModeling;
        }

        public void origin(OpenVector3f origin) {
            this.origin = origin;
        }

        public void rotation(OpenVector3f rotation) {
            this.rotation = rotation;
        }

        public void uvOffset(OpenVector2f uvOffset) {
            this.uvOffset = uvOffset;
        }

        public void addFace(String key, BlockBenchMeshFace face) {
            this.faces.put(key, face);
        }

        public void addVertex(String key, OpenVector3f vertex) {
            this.vertices.put(key, vertex);
        }

        @Override
        public BlockBenchMesh build() {
            return new BlockBenchMesh(this.uuid, this.name, this.type, this.allowExport, this.allowMirrorModeling, this.boxUV, this.mirrorUV, this.uvOffset, this.origin, this.rotation, this.faces, this.vertices);
        }
    }
}

