/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchObject;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class BlockBenchKeyframe
extends BlockBenchObject {
    private final float time;
    private final String interpolation;
    private final List<Float> parameters;
    private final List<Map<String, OpenPrimitive>> points;

    public BlockBenchKeyframe(String uuid, String name, float time, String interpolation, List<Float> parameters, List<Map<String, OpenPrimitive>> points) {
        super(uuid, name);
        this.time = time;
        this.interpolation = interpolation;
        this.parameters = parameters;
        this.points = points;
    }

    public float getTime() {
        return this.time;
    }

    public String getInterpolation() {
        return this.interpolation;
    }

    public List<Float> getParameters() {
        return this.parameters;
    }

    public List<Map<String, OpenPrimitive>> getPoints() {
        return this.points;
    }

    protected static class Builder
    extends BlockBenchObject.Builder {
        private float time = 0.0f;
        private String interpolation = "liner";
        private List<Float> parameters;
        private final List<Map<String, OpenPrimitive>> points = new ArrayList<Map<String, OpenPrimitive>>();

        protected Builder() {
        }

        public void time(float time) {
            this.time = time;
        }

        public void interpolation(String interpolation) {
            this.interpolation = interpolation;
        }

        public void parameters(List<Float> parameters) {
            this.parameters = parameters;
        }

        public void point(Map<String, OpenPrimitive> point) {
            this.points.add(point);
        }

        public BlockBenchKeyframe build() {
            return new BlockBenchKeyframe(this.uuid, this.name, this.time, this.interpolation, this.parameters, this.points);
        }
    }
}

