/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchCubeFace;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchElement;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class BlockBenchCube
extends BlockBenchElement {
    private final boolean boxUV;
    private final boolean mirrorUV;
    private final boolean allowMirrorModeling;
    private final OpenVector2f uvOffset;
    private final OpenVector3f from;
    private final OpenVector3f to;
    private final OpenVector3f origin;
    private final OpenVector3f rotation;
    private final float inflate;
    private final Map<OpenDirection, BlockBenchCubeFace> faces;

    public BlockBenchCube(String uuid, String name, String type, boolean allowExport, boolean allowMirrorModeling, boolean boxUV, boolean mirrorUV, OpenVector2f uvOffset, OpenVector3f from, OpenVector3f to, OpenVector3f origin, OpenVector3f rotation, float inflate, Map<OpenDirection, BlockBenchCubeFace> faces) {
        super(uuid, name, type, allowExport);
        this.boxUV = boxUV;
        this.mirrorUV = mirrorUV;
        this.allowMirrorModeling = allowMirrorModeling;
        this.uvOffset = uvOffset;
        this.from = from;
        this.to = to;
        this.origin = origin;
        this.rotation = rotation;
        this.inflate = inflate;
        this.faces = faces;
    }

    public OpenVector3f getFrom() {
        return this.from;
    }

    public OpenVector3f getTo() {
        return this.to;
    }

    public OpenVector3f getOrigin() {
        return this.origin;
    }

    public OpenVector3f getRotation() {
        return this.rotation;
    }

    public float getInflate() {
        return this.inflate;
    }

    public boolean isBoxUV() {
        return this.boxUV;
    }

    public boolean isMirrorUV() {
        return this.mirrorUV;
    }

    public OpenVector2f getUVOffset() {
        return this.uvOffset;
    }

    public Map<OpenDirection, BlockBenchCubeFace> getFaces() {
        return this.faces;
    }

    protected static class Builder
    extends BlockBenchElement.Builder {
        protected boolean boxUV = false;
        protected boolean mirrorUV = false;
        protected boolean allowMirrorModeling = false;
        protected OpenVector2f uvOffset = OpenVector2f.ZERO;
        protected OpenVector3f from = OpenVector3f.ZERO;
        protected OpenVector3f to = OpenVector3f.ZERO;
        protected OpenVector3f origin = OpenVector3f.ZERO;
        protected OpenVector3f rotation = OpenVector3f.ZERO;
        protected float inflate = 0.0f;
        protected final Map<OpenDirection, BlockBenchCubeFace> faces = new HashMap<OpenDirection, BlockBenchCubeFace>();

        protected Builder() {
        }

        public void boxUV(boolean boxUV) {
            this.boxUV = boxUV;
        }

        public void mirrorUV(boolean mirrorUV) {
            this.mirrorUV = mirrorUV;
        }

        public void allowMirrorModeling(boolean allowMirrorModeling) {
            this.allowMirrorModeling = allowMirrorModeling;
        }

        public void from(OpenVector3f from) {
            this.from = from;
        }

        public void to(OpenVector3f to) {
            this.to = to;
        }

        public void origin(OpenVector3f origin) {
            this.origin = origin;
        }

        public void rotation(OpenVector3f rotation) {
            this.rotation = rotation;
        }

        public void inflate(float inflate) {
            this.inflate = inflate;
        }

        public void uvOffset(OpenVector2f uvOffset) {
            this.uvOffset = uvOffset;
        }

        public void addFace(OpenDirection dir, BlockBenchCubeFace face) {
            this.faces.put(dir, face);
        }

        @Override
        public BlockBenchCube build() {
            return new BlockBenchCube(this.uuid, this.name, this.type, this.allowExport, this.allowMirrorModeling, this.boxUV, this.mirrorUV, this.uvOffset, this.from, this.to, this.origin, this.rotation, this.inflate, this.faces);
        }
    }
}

