/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock;

import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockCurve;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockEvent;

public class BedrockParticle {
    private final String name;
    private final String material;
    private final String texture;
    private final Map<String, BedrockCurve> curves;
    private final Map<String, BedrockComponent> components;
    private final Map<String, BedrockEvent> events;
    private final String format;

    public BedrockParticle(String name, String material, String texture, Map<String, BedrockCurve> curves, Map<String, BedrockComponent> components, Map<String, BedrockEvent> events, String format) {
        this.name = name;
        this.material = material;
        this.texture = texture;
        this.curves = curves;
        this.components = components;
        this.events = events;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getMaterial() {
        return this.material;
    }

    public String getTexture() {
        return this.texture;
    }

    public Map<String, BedrockCurve> getCurves() {
        return this.curves;
    }

    public Map<String, BedrockComponent> getComponents() {
        return this.components;
    }

    public Map<String, BedrockEvent> getEvents() {
        return this.events;
    }

    public String getFormat() {
        return this.format;
    }

    protected static class Builder {
        private String format = "1.10";
        private String name = "";
        private String material = "";
        private String texture = "";
        private final Map<String, BedrockCurve> curves = new LinkedHashMap<String, BedrockCurve>();
        private final Map<String, BedrockComponent> components = new LinkedHashMap<String, BedrockComponent>();
        private final Map<String, BedrockEvent> events = new LinkedHashMap<String, BedrockEvent>();

        protected Builder() {
        }

        public void format(String format) {
            this.format = format;
        }

        public void name(String name) {
            this.name = name;
        }

        public void material(String material) {
            this.material = material;
        }

        public void texture(String texture) {
            this.texture = texture;
        }

        public void addCurve(String name, BedrockCurve curve) {
            this.curves.put(name, curve);
        }

        public void addComponent(String name, BedrockComponent component) {
            this.components.put(name, component);
        }

        public void addEvent(String name, BedrockEvent event) {
            this.events.put(name, event);
        }

        public BedrockParticle build() {
            return new BedrockParticle(this.name, this.material, this.texture, this.curves, this.components, this.events, this.format);
        }
    }
}

