/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenSize2i;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.OptimizeContext;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleData;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleFacing;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleMaterial;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.EmitterInitialLocalSpace;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.EmitterInitialization;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterEventLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterExpressionLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterLoopingLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterOnceLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterInstantRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterManualRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterSteadyRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterBoxShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterDiscShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterEntityShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterPointShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterShapeDirection;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterSphereShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialSpeed;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialSpin;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialization;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleBillboardAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleLightingAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleTintingAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleEventLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleExpressLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleKillInBlocksLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleKillInPlaneLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleOnlyInBlocksLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleCollisionMotion;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleDynamicMotion;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleParametricMotion;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockPack;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockParticle;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenExpression;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;
import moe.plushie.armourers_workshop.init.ModConstants;

public class BedrockExporter {
    protected final BedrockPack pack;
    protected final MolangVirtualMachine virtualMachine;

    public BedrockExporter(BedrockPack pack, MolangVirtualMachine virtualMachine) {
        this.pack = pack;
        this.virtualMachine = virtualMachine;
    }

    public SkinParticleData exportParticle(BedrockParticle particle) {
        String name = particle.getName();
        SkinParticleMaterial meterial = this.toParticleMaterial(particle.getMaterial());
        SkinTextureData texutre = this.toParticleTexture(particle.getTexture());
        ArrayList<SkinParticleComponent> components = new ArrayList<SkinParticleComponent>();
        for (BedrockComponent component : particle.getComponents().values()) {
            components.add(this.exportParticleComponent(component));
        }
        return new SkinParticleData(name, meterial, texutre, components);
    }

    protected SkinParticleComponent exportParticleComponent(BedrockComponent component) {
        if (component instanceof BedrockComponent.EmitterInitialization) {
            BedrockComponent.EmitterInitialization comp = (BedrockComponent.EmitterInitialization)component;
            OpenPrimitive creation = this.convertToExpression(comp.getCreation());
            OpenPrimitive update = this.convertToExpression(comp.getUpdate());
            return new EmitterInitialization(creation, update);
        }
        if (component instanceof BedrockComponent.EmitterLocalSpace) {
            BedrockComponent.EmitterLocalSpace comp = (BedrockComponent.EmitterLocalSpace)component;
            boolean position = comp.isPosition();
            boolean rotation = comp.isRotation();
            boolean velocity = comp.isVelocity();
            return new EmitterInitialLocalSpace(position, rotation, velocity);
        }
        if (component instanceof BedrockComponent.EmitterSteadyRate) {
            BedrockComponent.EmitterSteadyRate comp = (BedrockComponent.EmitterSteadyRate)component;
            OpenPrimitive spawnRate = this.convertToFloatExpression(comp.getSpawnRate());
            OpenPrimitive maxParticles = this.convertToIntExpression(comp.getMaxParticles());
            return new EmitterSteadyRate(spawnRate, maxParticles);
        }
        if (component instanceof BedrockComponent.EmitterInstantRate) {
            BedrockComponent.EmitterInstantRate comp = (BedrockComponent.EmitterInstantRate)component;
            OpenPrimitive particles = this.convertToIntExpression(comp.getParticles());
            return new EmitterInstantRate(particles);
        }
        if (component instanceof BedrockComponent.EmitterManualRate) {
            BedrockComponent.EmitterManualRate comp = (BedrockComponent.EmitterManualRate)component;
            OpenPrimitive maxParticles = this.convertToIntExpression(comp.getMaxParticles());
            return new EmitterManualRate(maxParticles);
        }
        if (component instanceof BedrockComponent.EmitterEventLifetime) {
            BedrockComponent.EmitterEventLifetime comp = (BedrockComponent.EmitterEventLifetime)component;
            List<String> creation = comp.getCreation();
            List<String> expiration = comp.getExpiration();
            LinkedHashMap<Float, List<String>> timelineEvents = new LinkedHashMap<Float, List<String>>();
            LinkedHashMap<Float, List<String>> travelDistanceEvents = new LinkedHashMap<Float, List<String>>();
            Map<Float, List<String>> travelDistanceLoopEvents = comp.getTravelDistanceLoopEvents();
            comp.getTimelineEvents().forEach((key, value) -> timelineEvents.put(Float.valueOf(Float.parseFloat(key)), (List<String>)value));
            comp.getTravelDistanceEvents().forEach((key, value) -> travelDistanceEvents.put(Float.valueOf(Float.parseFloat(key)), (List<String>)value));
            return new EmitterEventLifetime(creation, expiration, timelineEvents, travelDistanceEvents, travelDistanceLoopEvents);
        }
        if (component instanceof BedrockComponent.EmitterExpressionLifetime) {
            BedrockComponent.EmitterExpressionLifetime comp = (BedrockComponent.EmitterExpressionLifetime)component;
            OpenPrimitive activation = this.convertToExpression(comp.getActivation());
            OpenPrimitive expiration = this.convertToExpression(comp.getExpiration());
            return new EmitterExpressionLifetime(activation, expiration);
        }
        if (component instanceof BedrockComponent.EmitterLoopingLifetime) {
            BedrockComponent.EmitterLoopingLifetime comp = (BedrockComponent.EmitterLoopingLifetime)component;
            OpenPrimitive activeTime = this.convertToFloatExpression(comp.getActiveTime());
            OpenPrimitive sleepTime = this.convertToFloatExpression(comp.getSleepTime());
            return new EmitterLoopingLifetime(activeTime, sleepTime);
        }
        if (component instanceof BedrockComponent.EmitterOnceLifetime) {
            BedrockComponent.EmitterOnceLifetime comp = (BedrockComponent.EmitterOnceLifetime)component;
            OpenPrimitive activeTime = this.convertToFloatExpression(comp.getActiveTime());
            return new EmitterOnceLifetime(activeTime);
        }
        if (component instanceof BedrockComponent.EmitterBoxShape) {
            BedrockComponent.EmitterBoxShape comp = (BedrockComponent.EmitterBoxShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.getOffsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.getOffsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.getOffsetZ());
            OpenPrimitive width = this.convertToFloatExpression(comp.getSizeWidth());
            OpenPrimitive height = this.convertToFloatExpression(comp.getSizeHeight());
            OpenPrimitive depth = this.convertToFloatExpression(comp.getSizeDepth());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.getDirection());
            return new EmitterBoxShape(offsetX, offsetY, offsetZ, width, height, depth, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.EmitterDiscShape) {
            BedrockComponent.EmitterDiscShape comp = (BedrockComponent.EmitterDiscShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.getOffsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.getOffsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.getOffsetZ());
            OpenPrimitive radius = this.convertToFloatExpression(comp.getRadius());
            OpenPrimitive planeNormalX = this.convertToFloatExpression(comp.getPlaneNormalX());
            OpenPrimitive planeNormalY = this.convertToFloatExpression(comp.getPlaneNormalY());
            OpenPrimitive planeNormalZ = this.convertToFloatExpression(comp.getPlaneNormalZ());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.getDirection());
            return new EmitterDiscShape(offsetX, offsetY, offsetZ, radius, planeNormalX, planeNormalY, planeNormalZ, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.EmitterEntityShape) {
            BedrockComponent.EmitterEntityShape comp = (BedrockComponent.EmitterEntityShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.getOffsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.getOffsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.getOffsetZ());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.getDirection());
            return new EmitterEntityShape(offsetX, offsetY, offsetZ, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.EmitterPointShape) {
            BedrockComponent.EmitterPointShape comp = (BedrockComponent.EmitterPointShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.getOffsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.getOffsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.getOffsetZ());
            EmitterShapeDirection direction = this.toParticleDirection(comp.getDirection());
            return new EmitterPointShape(offsetX, offsetY, offsetZ, direction);
        }
        if (component instanceof BedrockComponent.EmitterSphereShape) {
            BedrockComponent.EmitterSphereShape comp = (BedrockComponent.EmitterSphereShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.getOffsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.getOffsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.getOffsetZ());
            OpenPrimitive radius = this.convertToFloatExpression(comp.getRadius());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.getDirection());
            return new EmitterSphereShape(offsetX, offsetY, offsetZ, radius, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.ParticleInitialization) {
            BedrockComponent.ParticleInitialization comp = (BedrockComponent.ParticleInitialization)component;
            OpenPrimitive update = this.convertToExpression(comp.getUpdate());
            OpenPrimitive render = this.convertToExpression(comp.getRender());
            return new ParticleInitialization(update, render);
        }
        if (component instanceof BedrockComponent.ParticleInitialSpeed) {
            BedrockComponent.ParticleInitialSpeed comp = (BedrockComponent.ParticleInitialSpeed)component;
            OpenPrimitive speed = this.convertToFloatExpression(comp.getSpeed());
            return new ParticleInitialSpeed(speed);
        }
        if (component instanceof BedrockComponent.ParticleInitialSpin) {
            BedrockComponent.ParticleInitialSpin comp = (BedrockComponent.ParticleInitialSpin)component;
            OpenPrimitive rotation = this.convertToFloatExpression(comp.getRotation());
            OpenPrimitive rotationRate = this.convertToFloatExpression(comp.getRotationRate());
            return new ParticleInitialSpin(rotation, rotationRate);
        }
        if (component instanceof BedrockComponent.ParticleEventLifetime) {
            BedrockComponent.ParticleEventLifetime comp = (BedrockComponent.ParticleEventLifetime)component;
            List<String> creation = comp.getCreation();
            List<String> expiration = comp.getExpiration();
            LinkedHashMap<Float, List<String>> timelineEvents = new LinkedHashMap<Float, List<String>>();
            comp.getTimelineEvents().forEach((key, value) -> timelineEvents.put(Float.valueOf(Float.parseFloat(key)), (List<String>)value));
            return new ParticleEventLifetime(creation, expiration, timelineEvents);
        }
        if (component instanceof BedrockComponent.ParticleExpressLifetime) {
            BedrockComponent.ParticleExpressLifetime comp = (BedrockComponent.ParticleExpressLifetime)component;
            OpenPrimitive maxAge = this.convertToIntExpression(comp.getMaxAge());
            OpenPrimitive expiration = this.convertToExpression(comp.getExpiration());
            return new ParticleExpressLifetime(maxAge, expiration);
        }
        if (component instanceof BedrockComponent.ParticleKillInBlocksLifetime) {
            BedrockComponent.ParticleKillInBlocksLifetime comp = (BedrockComponent.ParticleKillInBlocksLifetime)component;
            List<String> blocks = comp.getBlocks();
            return new ParticleKillInBlocksLifetime(blocks);
        }
        if (component instanceof BedrockComponent.ParticleKillInPlaneLifetime) {
            BedrockComponent.ParticleKillInPlaneLifetime comp = (BedrockComponent.ParticleKillInPlaneLifetime)component;
            float a = comp.getParameters().get(0).floatValue();
            float b = comp.getParameters().get(1).floatValue();
            float c = comp.getParameters().get(2).floatValue();
            float d = comp.getParameters().get(3).floatValue();
            return new ParticleKillInPlaneLifetime(a, b, c, d);
        }
        if (component instanceof BedrockComponent.ParticleOnlyInBlocksLifetime) {
            BedrockComponent.ParticleOnlyInBlocksLifetime comp = (BedrockComponent.ParticleOnlyInBlocksLifetime)component;
            List<String> blocks = comp.getBlocks();
            return new ParticleOnlyInBlocksLifetime(blocks);
        }
        if (component instanceof BedrockComponent.ParticleCollisionMotion) {
            BedrockComponent.ParticleCollisionMotion comp = (BedrockComponent.ParticleCollisionMotion)component;
            OpenPrimitive enabled = this.convertToFloatExpression(comp.getEnabled());
            float collisionDrag = comp.getCollisionDrag();
            float collisionRadius = comp.getCollisionRadius();
            float coefficientOfRestitution = comp.getCoefficientOfRestitution();
            boolean expireOnContact = comp.isExpireOnContact();
            Map<Float, String> events = comp.getEvents();
            return new ParticleCollisionMotion(enabled, collisionDrag, collisionRadius, coefficientOfRestitution, expireOnContact, events);
        }
        if (component instanceof BedrockComponent.ParticleDynamicMotion) {
            BedrockComponent.ParticleDynamicMotion comp = (BedrockComponent.ParticleDynamicMotion)component;
            OpenPrimitive linearAccelerationX = this.convertToFloatExpression(comp.getLinearAccelerationX());
            OpenPrimitive linearAccelerationY = this.convertToFloatExpression(comp.getLinearAccelerationY());
            OpenPrimitive linearAccelerationZ = this.convertToFloatExpression(comp.getLinearAccelerationZ());
            OpenPrimitive linearDragCoefficient = this.convertToFloatExpression(comp.getLinearDragCoefficient());
            OpenPrimitive rotationAcceleration = this.convertToFloatExpression(comp.getRotationAcceleration());
            OpenPrimitive rotationDragCoefficient = this.convertToFloatExpression(comp.getRotationDragCoefficient());
            return new ParticleDynamicMotion(linearAccelerationX, linearAccelerationY, linearAccelerationZ, linearDragCoefficient, rotationAcceleration, rotationDragCoefficient);
        }
        if (component instanceof BedrockComponent.ParticleParametricMotion) {
            BedrockComponent.ParticleParametricMotion comp = (BedrockComponent.ParticleParametricMotion)component;
            OpenPrimitive relativePositionX = this.convertToFloatExpression(comp.getRelativePositionX());
            OpenPrimitive relativePositionY = this.convertToFloatExpression(comp.getRelativePositionY());
            OpenPrimitive relativePositionZ = this.convertToFloatExpression(comp.getRelativePositionZ());
            OpenPrimitive directionX = this.convertToFloatExpression(comp.getDirectionX());
            OpenPrimitive directionY = this.convertToFloatExpression(comp.getDirectionY());
            OpenPrimitive directionZ = this.convertToFloatExpression(comp.getDirectionZ());
            OpenPrimitive rotation = this.convertToFloatExpression(comp.getRotation());
            return new ParticleParametricMotion(relativePositionX, relativePositionY, relativePositionZ, directionX, directionY, directionZ, rotation);
        }
        if (component instanceof BedrockComponent.ParticleLightingAppearance) {
            BedrockComponent.ParticleLightingAppearance comp = (BedrockComponent.ParticleLightingAppearance)component;
            return new ParticleLightingAppearance();
        }
        if (component instanceof BedrockComponent.ParticleBillboardAppearance) {
            BedrockComponent.ParticleBillboardAppearance comp = (BedrockComponent.ParticleBillboardAppearance)component;
            OpenPrimitive width = this.convertToFloatExpression(comp.getWidth());
            OpenPrimitive height = this.convertToFloatExpression(comp.getHeight());
            SkinParticleFacing facingCameraMode = this.toParticleFacing(comp.getFacingCameraMode());
            OpenSize2i textureSize = comp.getTextureSize();
            OpenPrimitive textureCoordsX = this.convertToFloatExpression(comp.getTextureCoordsX());
            OpenPrimitive textureCoordsY = this.convertToFloatExpression(comp.getTextureCoordsY());
            OpenPrimitive textureCoordsWidth = this.convertToFloatExpression(comp.getTextureCoordsWidth());
            OpenPrimitive textureCoordsHeight = this.convertToFloatExpression(comp.getTextureCoordsHeight());
            OpenPrimitive stepX = this.convertToFloatExpression(comp.getStepX());
            OpenPrimitive stepY = this.convertToFloatExpression(comp.getStepY());
            boolean isUseAnimation = comp.isUseAnimation();
            int fps = comp.getFps();
            OpenPrimitive maxFrame = this.convertToIntExpression(comp.getMaxFrame());
            boolean isStretchToLifetime = comp.isStretchToLifetime();
            boolean isLoop = comp.isLoop();
            return new ParticleBillboardAppearance(width, height, facingCameraMode, textureSize, textureCoordsX, textureCoordsY, textureCoordsWidth, textureCoordsHeight, stepX, stepY, isUseAnimation, fps, maxFrame, isStretchToLifetime, isLoop);
        }
        if (component instanceof BedrockComponent.ParticleTintingAppearance) {
            BedrockComponent.ParticleTintingAppearance comp = (BedrockComponent.ParticleTintingAppearance)component;
            List<OpenExpression> colors = comp.getValues();
            if (!colors.isEmpty()) {
                OpenPrimitive red = this.convertToFloatExpression(colors.get(0));
                OpenPrimitive green = this.convertToFloatExpression(colors.get(1));
                OpenPrimitive blue = this.convertToFloatExpression(colors.get(2));
                OpenPrimitive alpha = this.convertToFloatExpression(colors.get(3));
                return new ParticleTintingAppearance(red, green, blue, alpha);
            }
            OpenPrimitive interpolation = this.convertToFloatExpression(comp.getInterpolation());
            LinkedHashMap<Float, Integer> gradientColors = new LinkedHashMap<Float, Integer>();
            comp.getGradientValues().forEach((key, value) -> gradientColors.put(Float.valueOf(Float.parseFloat(key)), Integer.parseInt(value)));
            return new ParticleTintingAppearance(interpolation, gradientColors);
        }
        throw new RuntimeException("can't parse particle component!!");
    }

    private SkinParticleMaterial toParticleMaterial(String material) {
        return switch (material) {
            case "particles_alpha" -> SkinParticleMaterial.ALPHA;
            case "particles_add" -> SkinParticleMaterial.ADDITIVE;
            case "particles_blend" -> SkinParticleMaterial.BLEND;
            case "particles_opaque" -> SkinParticleMaterial.OPAQUE;
            default -> throw new IllegalArgumentException("Unknown particle material: " + material);
        };
    }

    private SkinTextureData toParticleTexture(String texture) {
        return switch (texture) {
            case "textures/particle/particles" -> this.createBuiltinTexture("textures/particle/particles", 128, 128);
            case "textures/particle/campfire_smoke" -> this.createBuiltinTexture("textures/particle/campfire_smoke", 16, 192);
            case "textures/particle/flame_atlas" -> this.createBuiltinTexture("textures/particle/flame_atlas", 16, 512);
            case "textures/particle/soul" -> this.createBuiltinTexture("textures/particle/soul", 16, 176);
            default -> throw new IllegalArgumentException("Unknown particle texture: " + texture);
        };
    }

    private EmitterShapeDirection toParticleDirection(Object direction) {
        if (Objects.equals(direction, "inwards")) {
            return EmitterShapeDirection.outwards();
        }
        if (Objects.equals(direction, "outwards")) {
            return EmitterShapeDirection.outwards();
        }
        if (direction instanceof List) {
            List value = (List)direction;
            OpenPrimitive x = this.convertToFloatExpression((OpenExpression)value.get(0));
            OpenPrimitive y = this.convertToFloatExpression((OpenExpression)value.get(1));
            OpenPrimitive z = this.convertToFloatExpression((OpenExpression)value.get(2));
            return EmitterShapeDirection.custom(x, y, z);
        }
        throw new IllegalArgumentException("unknown particle shape direction: " + String.valueOf(direction));
    }

    private SkinParticleFacing toParticleFacing(String name) {
        return switch (name) {
            case "rotate_xyz" -> SkinParticleFacing.ROTATE_XYZ;
            case "rotate_y" -> SkinParticleFacing.ROTATE_Y;
            case "lookat_xyz" -> SkinParticleFacing.LOOKAT_XYZ;
            case "lookat_y" -> SkinParticleFacing.LOOKAT_Y;
            case "lookat_direction" -> SkinParticleFacing.LOOKAT_DIRECTION;
            case "direction_x" -> SkinParticleFacing.DIRECTION_X;
            case "direction_y" -> SkinParticleFacing.DIRECTION_Y;
            case "direction_z" -> SkinParticleFacing.DIRECTION_Z;
            case "emitter_transform_xy" -> SkinParticleFacing.EMITTER_TRANSFORM_XY;
            case "emitter_transform_xz" -> SkinParticleFacing.EMITTER_TRANSFORM_XZ;
            case "emitter_transform_yz" -> SkinParticleFacing.EMITTER_TRANSFORM_YZ;
            default -> SkinParticleFacing.ROTATE_XYZ;
        };
    }

    private OpenPrimitive convertToExpression(OpenExpression value) {
        Expression expr = this.compileExpression(value);
        if (expr != null && expr.isMutable()) {
            return OpenPrimitive.of(value.getExpression());
        }
        return OpenPrimitive.NULL;
    }

    private OpenPrimitive convertToIntExpression(OpenExpression value) {
        Expression expr = this.compileExpression(value);
        if (expr != null && expr.isMutable()) {
            return OpenPrimitive.of(value.getExpression());
        }
        if (expr != null) {
            return OpenPrimitive.of(expr.evaluate(OptimizeContext.DEFAULT).getAsInt());
        }
        return OpenPrimitive.NULL;
    }

    private OpenPrimitive convertToFloatExpression(OpenExpression value) {
        Expression expr = this.compileExpression(value);
        if (expr != null && expr.isMutable()) {
            return OpenPrimitive.of(value.getExpression());
        }
        if (expr != null) {
            return OpenPrimitive.of((float)expr.compute(OptimizeContext.DEFAULT));
        }
        return OpenPrimitive.NULL;
    }

    private Expression compileExpression(OpenExpression value) {
        try {
            if (value == null) {
                return null;
            }
            String expr = value.getExpression();
            if (!expr.isEmpty()) {
                return this.virtualMachine.compile(value.getExpression());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private SkinTextureData createBuiltinTexture(String texture, int width, int height) {
        return new SkinTextureData(ModConstants.key(texture).toString(), width, height);
    }
}

