/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock;

import java.util.List;
import moe.plushie.armourers_workshop.core.utils.OpenExpression;

public class BedrockCurve {
    private final String type;
    private final OpenExpression input;
    private final OpenExpression range;
    private final List<Float> parameters;

    public BedrockCurve(String type, OpenExpression input, OpenExpression range, List<Float> parameters) {
        this.type = type;
        this.input = input;
        this.range = range;
        this.parameters = parameters;
    }

    public String getType() {
        return this.type;
    }

    public OpenExpression getInput() {
        return this.input;
    }

    public OpenExpression getRange() {
        return this.range;
    }

    public List<Float> getParameters() {
        return this.parameters;
    }

    protected static class Builder {
        private String type = "linear";
        private OpenExpression input;
        private OpenExpression range;
        private List<Float> parameters = null;

        protected Builder() {
        }

        public void type(String type) {
            this.type = type;
        }

        public void input(OpenExpression input) {
            this.input = input;
        }

        public void range(OpenExpression range) {
            this.range = range;
        }

        public void parameters(List<Float> parameters) {
            this.parameters = parameters;
        }

        public BedrockCurve build() {
            return new BedrockCurve(this.type, this.input, this.range, this.parameters);
        }
    }
}

