/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer;

import com.google.gson.JsonElement;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenSize2f;
import moe.plushie.armourers_workshop.core.math.OpenSize3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.PackResource;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer2;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.OpenExpression;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class PackObject
implements IODataObject {
    private final JsonElement element;

    public PackObject(IODataObject object) {
        this.element = object.jsonValue();
    }

    @Nullable
    public static PackObject from(PackResource resource) throws IOException {
        PackObject packObject;
        if (resource == null) {
            return null;
        }
        BufferedInputStream inputStream = new BufferedInputStream(resource.getInputStream());
        try {
            packObject = new PackObject(JsonSerializer.readFromStream(inputStream));
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        inputStream.close();
        return packObject;
    }

    public OpenExpression expression() {
        if (this.isNull()) {
            return null;
        }
        return new OpenExpression(this.stringValue());
    }

    public OpenVector2i vector2iValue() {
        Collection<IODataObject> values = this.allValues();
        if (values.size() >= 2) {
            Iterator<IODataObject> iterator = values.iterator();
            return new OpenVector2i(iterator.next().intValue(), iterator.next().intValue());
        }
        return OpenVector2i.ZERO;
    }

    public OpenVector2f vector2fValue() {
        Collection<IODataObject> values = this.allValues();
        if (values.size() >= 2) {
            Iterator<IODataObject> iterator = values.iterator();
            return new OpenVector2f(iterator.next().floatValue(), iterator.next().floatValue());
        }
        return OpenVector2f.ZERO;
    }

    public OpenSize2f size2fValue() {
        Collection<IODataObject> values = this.allValues();
        if (values.size() >= 2) {
            Iterator<IODataObject> iterator = values.iterator();
            return new OpenSize2f(iterator.next().floatValue(), iterator.next().floatValue());
        }
        return OpenSize2f.ZERO;
    }

    public OpenRectangle2f rectangle2fValue() {
        Collection<IODataObject> values = this.allValues();
        if (values.size() >= 4) {
            Iterator<IODataObject> iterator = values.iterator();
            float x1 = iterator.next().floatValue();
            float y1 = iterator.next().floatValue();
            float x2 = iterator.next().floatValue();
            float y2 = iterator.next().floatValue();
            return new OpenRectangle2f(x1, y1, x2 - x1, y2 - y1);
        }
        return OpenRectangle2f.ZERO;
    }

    public OpenSize3f size3fValue() {
        Collection<IODataObject> values = this.allValues();
        if (values.size() >= 3) {
            Iterator<IODataObject> iterator = values.iterator();
            return new OpenSize3f(iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue());
        }
        return OpenSize3f.ZERO;
    }

    public OpenVector3f vector3fValue() {
        Collection<IODataObject> values = this.allValues();
        if (values.size() >= 3) {
            Iterator<IODataObject> iterator = values.iterator();
            return new OpenVector3f(iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue());
        }
        return OpenVector3f.ZERO;
    }

    public void at(String keyPath, IOConsumer<PackObject> consumer) throws IOException {
        PackObject object = this.by(keyPath);
        if (object.isNull()) {
            return;
        }
        consumer.accept(new PackObject(this.by(keyPath)));
    }

    public void each(String keyPath, IOConsumer<PackObject> consumer) throws IOException {
        PackObject object = this.by(keyPath);
        if (object.isNull()) {
            return;
        }
        for (IODataObject value : object.allValues()) {
            consumer.accept(new PackObject(value));
        }
    }

    public void each(String keyPath, IOConsumer2<String, PackObject> consumer) throws IOException {
        PackObject object = this.by(keyPath);
        if (object.isNull()) {
            return;
        }
        for (Pair<String, IODataObject> pair : object.entrySet()) {
            consumer.accept((String)pair.getKey(), new PackObject((IODataObject)pair.getValue()));
        }
    }

    @Override
    public PackObject at(int index) {
        return new PackObject(IODataObject.super.at(index));
    }

    @Override
    public PackObject get(String key) {
        return new PackObject(IODataObject.super.get(key));
    }

    public PackObject by(String keyPath) {
        if (this.has(keyPath)) {
            return this.get(keyPath);
        }
        String[] keys = keyPath.split("\\.");
        PackObject object = this;
        for (String key : keys) {
            object = object.get(key);
        }
        return object;
    }

    @Override
    public JsonElement jsonValue() {
        return this.element;
    }
}

