/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometrySet;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFaceCuller;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.serializer.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.serializer.exporter.SkinExporter;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModLog;

public class SkinExporterPolygon
implements SkinExporter {
    private static final String CRLF = "\n";

    @Override
    public Collection<String> getExtensions() {
        return Collections.singleton("ply");
    }

    @Override
    public void exportSkin(Skin skin, File filePath, String filename, float scale) throws Exception {
        int partIndex = 0;
        for (SkinPart skinPart : skin.getParts()) {
            this.exportPart(skinPart, skin, filePath, filename, scale, partIndex++);
        }
    }

    private void exportPart(SkinPart skinPart, Skin skin, File filePath, String filename, float scale, int partIndex) throws IOException {
        Task task = new Task(skin, skinPart);
        HashMap<ISkinGeometryType, ArrayList> faces = new HashMap<ISkinGeometryType, ArrayList>();
        for (SkinCubeFace face : task.cubeFaces) {
            if (!face.isVisible()) continue;
            faces.computeIfAbsent(face.getType(), k -> new ArrayList()).add(face);
        }
        String[] layerNames = new String[]{"opaque", "glowing", "transparent", "transparent-glowing"};
        for (int i = 0; i < SkinGeometryTypes.getTotalCubes(); ++i) {
            ArrayList faces1 = (ArrayList)faces.get(SkinGeometryTypes.byId(i));
            if (faces1 == null || faces1.isEmpty()) continue;
            this.exportLayer(faces1, skinPart, skin, filePath, filename, scale, layerNames[i], partIndex);
        }
    }

    private void exportLayer(ArrayList<SkinCubeFace> faces, SkinPart skinPart, Skin skin, File filePath, String filename, float scale, String layer, int partIndex) throws IOException {
        ModLog.debug("export {} layer of {}:{}, faces: {}", layer, partIndex, skinPart.getType(), faces.size());
        Object finalName = filename;
        finalName = (String)finalName + "-" + partIndex;
        finalName = (String)finalName + "-" + skinPart.getType().getRegistryName().getPath();
        finalName = (String)finalName + "-" + layer;
        finalName = (String)finalName + ".ply";
        FileOutputStream outputStream = new FileOutputStream(new File(filePath, (String)finalName), false);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.US_ASCII);
        os.write("ply\n");
        os.write("format ascii 1.0\n");
        os.write("comment made by RiskyKen\n");
        os.write("comment This file was exported from the Minecraft mod Armourer's Workshop\n");
        os.write("element vertex " + faces.size() * 4 + CRLF);
        os.write("property float x\n");
        os.write("property float y\n");
        os.write("property float z\n");
        os.write("property uchar red\n");
        os.write("property uchar green\n");
        os.write("property uchar blue\n");
        os.write("element face " + faces.size() + CRLF);
        os.write("property list uchar int vertex_index\n");
        os.write("end_header\n");
        os.flush();
        OpenPoseStack poseStack = new OpenPoseStack();
        poseStack.scale(scale, scale, scale);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(90.0f));
        for (SkinCubeFace face : faces) {
            OpenRectangle3f shape = face.getBoundingBox();
            float x = shape.x();
            float y = shape.y();
            float z = shape.z();
            float w = shape.width();
            float h = shape.height();
            float d = shape.depth();
            float[][] vertexes = SkinCubeFace.getBaseVertices(face.getDirection());
            for (int i = 0; i < 4; ++i) {
                this.writeVert(poseStack, os, x + vertexes[i][0] * w, y + vertexes[i][1] * h, z + vertexes[i][2] * d, face.getColor());
            }
        }
        for (int i = 0; i < faces.size(); ++i) {
            os.write(String.format("4 %d %d %d %d", 4 * i, 4 * i + 1, 4 * i + 2, 4 * i + 3) + CRLF);
        }
        os.flush();
        outputStream.flush();
        outputStream.close();
    }

    private void writeVert(OpenPoseStack poseStack, OutputStreamWriter os, float x, float y, float z, SkinPaintColor color) throws IOException {
        OpenVector4f q = new OpenVector4f(x, y, z, 1.0f);
        q.transform(poseStack.last().pose());
        os.write(String.format("%s %s %s %d %d %d", this.f2s(q.x()), this.f2s(q.y()), this.f2s(q.z()), color.getRed(), color.getGreen(), color.getBlue()) + CRLF);
    }

    private String f2s(float value) {
        return SkinExportManager.FLOAT_FORMAT.format(value);
    }

    private static class Task {
        final Skin skin;
        final SkinPart skinPart;
        final ArrayList<SkinCubeFace> cubeFaces;

        Task(Skin skin, SkinPart skinPart) {
            ISkinGeometrySet geometries = skinPart.getGeometries();
            OpenRectangle3i bounds = new OpenRectangle3i(((SkinGeometrySet)geometries).getShape().bounds());
            this.skin = skin;
            this.skinPart = skinPart;
            this.cubeFaces = Collections.collect(SkinCubeFaceCuller.cullFaces(geometries, bounds), SkinCubeFace.class);
        }
    }
}

