/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.LinkedHashMap;
import java.util.Stack;
import moe.plushie.armourers_workshop.core.network.UpdateSkinDocumentPacket;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SkinDocumentSynchronizer
implements SkinDocumentListener {
    protected boolean isApplying = false;
    protected boolean isCapturing = false;
    protected boolean isClient = false;
    protected CompoundTag capturedPropertiesValues;
    protected CompoundTag capturedSettingValues;
    protected final LinkedHashMap<String, CompoundTag> capturedNodeValues = new LinkedHashMap();
    protected final Stack<Boolean> capturedStates = new Stack();
    protected final BlockEntity blockEntity;

    public SkinDocumentSynchronizer(BlockEntity blockEntity, boolean isClient) {
        this.blockEntity = blockEntity;
        this.isClient = isClient;
    }

    @Override
    public void documentDidChangeType(SkinDocumentType type) {
        this.post(new UpdateSkinDocumentPacket.ChangeTypeAction(type));
    }

    @Override
    public void documentDidChangeSettings(CompoundTag tag) {
        if (this.isCapturing) {
            if (this.capturedSettingValues != null) {
                this.capturedSettingValues.m_128391_(tag);
            } else {
                this.capturedSettingValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateSettingsAction(tag));
    }

    @Override
    public void documentDidChangeProperties(CompoundTag tag) {
        if (this.isCapturing) {
            if (this.capturedPropertiesValues != null) {
                this.capturedPropertiesValues.m_128391_(tag);
            } else {
                this.capturedPropertiesValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdatePropertiesAction(tag));
    }

    @Override
    public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        TagSerializer builder = new TagSerializer();
        target.serialize(builder);
        this.post(new UpdateSkinDocumentPacket.InsertNodeAction(node.getId(), index, builder.getTag()));
    }

    @Override
    public void documentDidUpdateNode(SkinDocumentNode node, CompoundTag tag) {
        if (this.isCapturing) {
            this.capturedNodeValues.computeIfAbsent(node.getId(), it -> tag).m_128391_(tag);
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateNodeAction(node.getId(), tag));
    }

    @Override
    public void documentDidRemoveNode(SkinDocumentNode node) {
        this.post(new UpdateSkinDocumentPacket.RemoveNodeAction(node.getId()));
    }

    @Override
    public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        this.post(new UpdateSkinDocumentPacket.MoveNodeAction(node.getId(), target.getId(), index));
    }

    @Override
    public void documentWillBeginEditing() {
        this.isApplying = true;
    }

    @Override
    public void documentDidEndEditing() {
        this.isApplying = false;
    }

    public void beginCapture() {
        this.capturedStates.push(this.isCapturing);
        this.isCapturing = true;
    }

    public void endCapture() {
        this.isCapturing = this.capturedStates.pop();
        if (this.isCapturing) {
            return;
        }
        if (this.capturedPropertiesValues != null) {
            this.documentDidChangeProperties(this.capturedPropertiesValues);
            this.capturedPropertiesValues = null;
        }
        if (this.capturedSettingValues != null) {
            this.documentDidChangeSettings(this.capturedSettingValues);
            this.capturedSettingValues = null;
        }
        this.capturedNodeValues.forEach((id, tag) -> this.post(new UpdateSkinDocumentPacket.UpdateNodeAction((String)id, (CompoundTag)tag)));
        this.capturedNodeValues.clear();
    }

    protected void post(UpdateSkinDocumentPacket.Action action) {
        if (this.isApplying) {
            return;
        }
        if (this.isClient) {
            NetworkManager.sendToServer(new UpdateSkinDocumentPacket(this.blockEntity, action));
        } else {
            NetworkManager.sendToTrackingBlock(new UpdateSkinDocumentPacket(this.blockEntity, action), this.blockEntity);
        }
    }
}

