/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinDyeType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;

public class SkinUsedCounter {
    private final Set<SkinDyeType> dyeTypes = new HashSet<SkinDyeType>();
    private final int[] geometryTotals = new int[SkinGeometryTypes.getTotalCubes()];
    private int markerTotal;
    private int geometryTotal;
    private int faceTotal;

    public void add(SkinUsedCounter counter) {
        this.markerTotal += counter.markerTotal;
        this.geometryTotal += counter.geometryTotal;
        for (int i = 0; i < this.geometryTotals.length; ++i) {
            this.geometryTotals[i] = this.geometryTotals[i] + counter.geometryTotals[i];
        }
    }

    public void addPaintType(Set<SkinPaintType> paintTypes) {
        if (paintTypes == null) {
            return;
        }
        for (SkinPaintType paintType : paintTypes) {
            if (paintType.getDyeType() == null) continue;
            this.dyeTypes.add(paintType.getDyeType());
        }
    }

    public void addGeometryType(ISkinGeometryType geometryType) {
        ++this.geometryTotal;
        int assignTransformLhsTemp44 = geometryType.getId();
        int cfr_ignored_0 = this.geometryTotals[assignTransformLhsTemp44] + 1;
    }

    public void addFaceTotal(int total) {
        this.faceTotal += total;
    }

    public void addMarkerTotal(int count) {
        this.markerTotal += count;
    }

    public void reset() {
        this.dyeTypes.clear();
        this.markerTotal = 0;
        this.geometryTotal = 0;
        Arrays.fill(this.geometryTotals, 0);
    }

    public SkinUsedCounter copy() {
        SkinUsedCounter result = new SkinUsedCounter();
        result.add(this);
        return result;
    }

    public int getDyeTotal() {
        return this.dyeTypes.size();
    }

    public Set<SkinDyeType> getDyeTypes() {
        return this.dyeTypes;
    }

    public int getMarkerTotal() {
        return this.markerTotal;
    }

    public int getGeometryTotal(ISkinGeometryType geometryType) {
        return this.geometryTotals[geometryType.getId()];
    }

    public int getGeometryTotal() {
        return this.geometryTotal;
    }
}

