/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer;

import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;

public class SkinFile
implements Comparable<SkinFile> {
    protected final String name;
    protected final String path;
    protected final DataDomain domain;
    protected final SkinFileHeader header;
    protected final boolean isDirectory;
    protected final boolean isPrivateDirectory;

    public SkinFile(DataDomain domain, String name, String path, SkinFileHeader header, boolean isDirectory, boolean isPrivateDirectory) {
        this.domain = domain;
        this.name = name;
        this.path = path;
        this.header = header;
        this.isDirectory = isDirectory;
        this.isPrivateDirectory = isPrivateDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.domain.namespace();
    }

    public String getPath() {
        return this.path;
    }

    public int getLastModified() {
        if (this.header != null) {
            return this.header.getLastModified();
        }
        return 0;
    }

    public int getSkinVersion() {
        if (this.header != null) {
            return this.header.getVersion();
        }
        return 0;
    }

    public String getSkinIdentifier() {
        return this.getNamespace() + ":" + this.getPath();
    }

    public SkinType getSkinType() {
        if (this.header != null) {
            return this.header.getType();
        }
        return null;
    }

    public SkinFileHeader getSkinHeader() {
        return this.header;
    }

    public SkinProperties getSkinProperties() {
        if (this.header != null) {
            return this.header.getProperties();
        }
        return null;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isPrivateDirectory() {
        return this.isPrivateDirectory;
    }

    @Override
    public int compareTo(SkinFile o) {
        if (this.isDirectory & !o.isDirectory) {
            return this.path.compareToIgnoreCase(o.path) - 1000000;
        }
        if (!this.isDirectory & o.isDirectory) {
            return this.path.compareToIgnoreCase(o.path) + 1000000;
        }
        return this.path.compareToIgnoreCase(o.path);
    }

    public String toString() {
        return this.domain.normalize(this.path);
    }

    public boolean isChildDirectory(String rootPath) {
        int length = rootPath.length();
        return length < this.path.length() && this.path.startsWith(rootPath) && this.path.indexOf(47, length) < 0;
    }
}

