/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterShapeDirection;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterPointShape
extends SkinParticleComponent {
    private final OpenPrimitive x;
    private final OpenPrimitive y;
    private final OpenPrimitive z;
    private final EmitterShapeDirection direction;

    public EmitterPointShape(OpenPrimitive x, OpenPrimitive y, OpenPrimitive z, EmitterShapeDirection direction) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
    }

    public EmitterPointShape(IInputStream stream) throws IOException {
        this.x = stream.readPrimitiveObject();
        this.y = stream.readPrimitiveObject();
        this.z = stream.readPrimitiveObject();
        this.direction = EmitterShapeDirection.readFromStream(stream);
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.x);
        stream.writePrimitiveObject(this.y);
        stream.writePrimitiveObject(this.z);
        this.direction.writeToStream(stream);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression x = builder.compile(this.x, 0.0);
        Expression y = builder.compile(this.y, 0.0);
        Expression z = builder.compile(this.z, 0.0);
        if (!this.direction.isBuiltin()) {
            // empty if block
        }
        builder.applyParticle((emitter, particle, context) -> {
            double tx = x.compute(context);
            double ty = y.compute(context);
            double tz = z.compute(context);
        });
    }
}

