/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part.bow;

import com.google.common.collect.Range;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanHeld;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanUse;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;

public class BowPartType
extends SkinPartType
implements ICanHeld,
ICanUse {
    private final int frame;
    private final Range<Integer> useRange;

    public BowPartType(int frame) {
        this.frame = frame;
        this.buildingSpace = new OpenRectangle3i(-12, -42, -46, 24, 84, 64);
        this.guideSpace = new OpenRectangle3i(-2, -2, 2, 4, 4, 8);
        this.offset = BowPartType.getFrameOffset(frame);
        this.useRange = BowPartType.getFrameUseRange(frame);
    }

    public static Range<Integer> getFrameUseRange(int frame) {
        return switch (frame) {
            case 0 -> Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
            case 1 -> Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12));
            case 2 -> Range.closed((Comparable)Integer.valueOf(13), (Comparable)Integer.valueOf(17));
            default -> Range.closed((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(30));
        };
    }

    public static OpenVector3i getFrameOffset(int frame) {
        return switch (frame) {
            case 0 -> new OpenVector3i(-50, 0, 0);
            case 1 -> new OpenVector3i(-25, 0, 0);
            case 2 -> new OpenVector3i(0, 0, 0);
            case 3 -> new OpenVector3i(25, 0, 0);
            default -> null;
        };
    }

    @Override
    public Range<Integer> getUseRange() {
        return this.useRange;
    }

    @Override
    public int getMinimumMarkersNeeded() {
        return 1;
    }

    @Override
    public int getMaximumMarkersNeeded() {
        return 1;
    }

    @Override
    public boolean isPartRequired() {
        return this.frame != 0;
    }
}

