/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.api.core.math.ITransform3f;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanRotation;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.wings.WingPartTransform;

public class SkinPartTransform
implements ITransform {
    public static final SkinPartTransform IDENTITY = new SkinPartTransform();
    private final ITransform parent;
    private final ArrayList<ITransform> children = new ArrayList();

    public SkinPartTransform() {
        this.parent = IDENTITY;
    }

    public SkinPartTransform(SkinPart part, ITransform quadsTransform) {
        ITransform partTransform;
        ITransform wingsTransform;
        this.parent = part.getTransform();
        if (quadsTransform != null) {
            this.children.add(quadsTransform);
        }
        if ((wingsTransform = this.getWingsTransform(part)) != null) {
            this.children.add(wingsTransform);
        }
        if ((partTransform = part.getTransform()) != null) {
            this.children.add(partTransform);
        }
    }

    private ITransform getWingsTransform(SkinPart part) {
        SkinPartType partType = part.getType();
        if (!(partType instanceof ICanRotation)) {
            return null;
        }
        Collection markers = part.getMarkers();
        if (markers == null || markers.isEmpty()) {
            return null;
        }
        return new WingPartTransform(partType, part.getProperties(), (SkinMarker)markers.iterator().next());
    }

    @Override
    public void apply(IPoseStack poseStack) {
        for (ITransform transform : this.children) {
            transform.apply(poseStack);
        }
    }

    public void addChild(ITransform transform) {
        this.children.add(transform);
    }

    public void insertChild(ITransform transform, int index) {
        this.children.add(index, transform);
    }

    public void replaceChild(ITransform oldTransform, ITransform newTransform) {
        int index = this.children.indexOf(oldTransform);
        if (index != -1) {
            this.children.set(index, newTransform);
        }
    }

    public void removeChild(ITransform transform) {
        this.children.remove(transform);
    }

    public List<ITransform> getChildren() {
        return this.children;
    }

    public ITransform getParent() {
        return this.parent;
    }

    public boolean isIdentity() {
        for (ITransform transform : this.children) {
            ITransform3f transform1;
            if (transform instanceof ITransform3f && (transform1 = (ITransform3f)transform).isIdentity()) continue;
            return false;
        }
        return true;
    }
}

