/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix1621;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EffectSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.ItemSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.LivingEntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EffectSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ItemSelectorImpl;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LivingEntitySelectorImpl<T extends LivingEntity>
extends EntitySelectorImpl<T>
implements LivingEntitySelector {
    private static final Map<String, Optional<EquipmentSlot>> NAMED_SLOTS = new ConcurrentHashMap<String, Optional<EquipmentSlot>>();
    private static final Map<String, EquipmentSlot> FIXED_SLOTS = Collections.immutableMap(builder -> {
        builder.put((Object)"chest", (Object)EquipmentSlot.CHEST);
        builder.put((Object)"feet", (Object)EquipmentSlot.FEET);
        builder.put((Object)"head", (Object)EquipmentSlot.HEAD);
        builder.put((Object)"legs", (Object)EquipmentSlot.LEGS);
        builder.put((Object)"mainhand", (Object)EquipmentSlot.MAINHAND);
        builder.put((Object)"offhand", (Object)EquipmentSlot.OFFHAND);
    });
    private final ItemSelectorImpl itemSelector = new ItemSelectorImpl();
    private final EffectSelectorImpl effectSelector = new EffectSelectorImpl();

    @Override
    public LivingEntitySelectorImpl<T> apply(T entity, ContextSelectorImpl context) {
        super.apply(entity, context);
        return this;
    }

    @Override
    public double getBodyYaw() {
        return MathHelper.lerp(this.getPartialTick(), ((LivingEntity)this.entity).f_19860_, ((LivingEntity)this.entity).m_146909_());
    }

    @Override
    public double getBodyPitch() {
        return MathHelper.wrapDegrees(MathHelper.lerp(this.getPartialTick(), ((LivingEntity)this.entity).f_19859_, ((LivingEntity)this.entity).m_146908_()));
    }

    @Override
    public double getHealth() {
        return ((LivingEntity)this.entity).m_21223_();
    }

    @Override
    public double getMaxHealth() {
        return ((LivingEntity)this.entity).m_21233_();
    }

    @Override
    public double getArmorValue() {
        return ((LivingEntity)this.entity).m_21230_();
    }

    @Override
    public double getHurtTime() {
        return ((LivingEntity)this.entity).f_20916_;
    }

    @Override
    public boolean isDeadOrDying() {
        return ((LivingEntity)this.entity).m_21224_();
    }

    @Override
    public boolean isEating() {
        return ((LivingEntity)this.entity).m_21211_().m_41780_() == UseAnim.EAT;
    }

    @Override
    public boolean isSleeping() {
        return ((LivingEntity)this.entity).m_5803_();
    }

    @Override
    public boolean isUsingItem() {
        return ((LivingEntity)this.entity).m_6117_();
    }

    @Override
    public boolean isAutoSpinAttack() {
        return ((LivingEntity)this.entity).m_21209_();
    }

    @Override
    public boolean isOnClimbable() {
        return ((LivingEntity)this.entity).m_6147_();
    }

    @Override
    public double getUsingItemDuration() {
        return (double)((LivingEntity)this.entity).m_21252_() / 20.0;
    }

    @Override
    public double getUsingItemMaxDuration() {
        ItemStack item = ((LivingEntity)this.entity).m_21211_();
        if (!item.m_41619_()) {
            return Fix1621.getUseDuration(item, (LivingEntity)this.entity) / 20.0;
        }
        return 0.0;
    }

    @Override
    public double getUsingItemRemainingDuration() {
        return (double)((LivingEntity)this.entity).m_21212_() / 20.0;
    }

    @Override
    public int getArrowCount() {
        return ((LivingEntity)this.entity).m_21234_();
    }

    @Override
    public int getStingerCount() {
        return ((LivingEntity)this.entity).m_21235_();
    }

    @Override
    public double getAttributeValue(String name) {
        return AbstractRegistryManager.getAttribute((LivingEntity)this.entity, name);
    }

    @Override
    @Nullable
    public EffectSelector getEffect(String name) {
        MobEffectInstance effect = AbstractRegistryManager.getEffect((LivingEntity)this.entity, name);
        if (effect != null) {
            return this.effectSelector.apply(effect);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemSelector getEquippedItem(String name) {
        Optional slot = NAMED_SLOTS.computeIfAbsent(name, LivingEntitySelectorImpl::findSlot);
        ItemStack itemStack = slot.map(it -> ((LivingEntity)this.entity).m_6844_(it)).orElse(ItemStack.f_41583_);
        if (!itemStack.m_41619_()) {
            return this.itemSelector.apply(itemStack);
        }
        return null;
    }

    @Override
    public int getEquipmentCount() {
        int count = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND || (stack = ((LivingEntity)this.entity).m_6844_(slot)).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getLastClimbableFacing() {
        Level level = PropertyProvider.getLevel(this.entity);
        if (level == null) {
            return 0;
        }
        Optional climbablePos = ((LivingEntity)this.entity).m_21227_();
        if (!climbablePos.isPresent()) {
            return 0;
        }
        BlockState blockState = level.m_8055_((BlockPos)climbablePos.get());
        Optional facing = blockState.m_61145_((Property)HorizontalDirectionalBlock.f_54117_);
        return facing.map(Direction::m_122416_).orElse(0);
    }

    private static Optional<EquipmentSlot> findSlot(String name) {
        return Optional.ofNullable(FIXED_SLOTS.get(name.toLowerCase()));
    }
}

