/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime.function.builtin;

import java.util.List;
import moe.plushie.armourers_workshop.core.skin.molang.core.Assignable;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Scope;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.function.Function;
import moe.plushie.armourers_workshop.init.ModLog;

public final class ForEach
extends Function {
    private final Expression var;
    private final Expression array;
    private final Expression body;

    public ForEach(Expression name, List<Expression> arguments) {
        super(name, 3, arguments);
        this.var = arguments.get(0);
        this.array = arguments.get(1);
        this.body = arguments.get(2);
    }

    @Override
    public double compute(ExecutionContext context) {
        return this.evaluate(context).getAsDouble();
    }

    @Override
    public Result evaluate(ExecutionContext context) {
        Expression expression = this.var;
        if (!(expression instanceof Assignable)) {
            ModLog.warn("Cannot assign a value to {}", this.var);
            return Result.NULL;
        }
        Assignable cur = (Assignable)expression;
        Result elements = this.array.evaluate(context);
        Scope scope = context.stack().scope().beginEnumerate();
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            cur.assign(elements.get(i), context);
            this.body.evaluate(context);
            if (scope.isBreakOrReturn()) break;
        }
        return scope.endEnumerate();
    }

    @Override
    public Expression receiver() {
        return this.var;
    }

    public Expression array() {
        return this.array;
    }

    public Expression body() {
        return this.body;
    }
}

