/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime.bind;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.core.NamedObject;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.VariableStorage;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.ObjectBinding;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.holder.ConstantHolder;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.holder.VariableHolder;

public abstract class VariableBinding
extends NamedObject
implements ObjectBinding {
    protected final Map<String, Expression> children = new ConcurrentHashMap<String, Expression>();

    protected abstract Expression build(Name var1);

    @Override
    public Expression getProperty(String name) {
        return this.children.computeIfAbsent(name.toLowerCase(), it -> {
            Expression holder = this.build(Name.of(it));
            if (holder instanceof NamedObject) {
                NamedObject namedObject = (NamedObject)((Object)holder);
                namedObject.setName((String)it, this);
            }
            return holder;
        });
    }

    public static class Temp
    extends VariableBinding {
        private final Map<Name, Integer> addresses = new ConcurrentHashMap<Name, Integer>();

        @Override
        protected Expression build(Name name) {
            final int address = this.addresses.computeIfAbsent(name, it -> this.addresses.size());
            return new VariableHolder(){

                @Override
                public Result assign(Result value, ExecutionContext context) {
                    context.stack().setVariable(address, value);
                    return value;
                }

                @Override
                public Result evaluate(ExecutionContext context) {
                    return context.stack().getVariable(address);
                }
            };
        }
    }

    public static class Scoped
    extends VariableBinding {
        @Override
        protected Expression build(final Name name) {
            return new VariableHolder(){

                @Override
                public Result assign(Result value, ExecutionContext context) {
                    VariableStorage entity = context.entity();
                    if (entity == null) {
                        return Result.NULL;
                    }
                    entity.setVariable(name, value);
                    return value;
                }

                @Override
                public Result evaluate(ExecutionContext context) {
                    VariableStorage entity = context.entity();
                    if (entity == null) {
                        return Result.NULL;
                    }
                    return entity.getVariable(name);
                }
            };
        }
    }

    public static class Foreign
    extends VariableBinding {
        @Override
        protected Expression build(final Name name) {
            return new ConstantHolder(){

                @Override
                public Result evaluate(ExecutionContext context) {
                    return context.getVariable(name);
                }
            };
        }
    }
}

