/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime;

import moe.plushie.armourers_workshop.core.skin.molang.core.Result;

public final class MathHelper {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;

    public static double cos(double value) {
        return Math.cos((float)value);
    }

    public static double clamp(double d, double e, double f) {
        return d < e ? e : Math.min(d, f);
    }

    public static int floor(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static int ceil(double d) {
        int i = (int)d;
        return d > (double)i ? i + 1 : i;
    }

    public static double lerp(double d, double e, double f) {
        return e + d * (f - e);
    }

    public static double lerpYaw(double delta, double start, double end) {
        double diff = (start = MathHelper.wrapDegrees(start)) - (end = MathHelper.wrapDegrees(end));
        end = diff > 180.0 || diff < -180.0 ? start + Math.copySign(360.0 - Math.abs(diff), diff) : end;
        return MathHelper.lerp(delta, start, end);
    }

    public static double wrapDegrees(double d) {
        double e = d % 360.0;
        if (e >= 180.0) {
            e -= 360.0;
        }
        if (e < -180.0) {
            e += 360.0;
        }
        return e;
    }

    public static Result add(Result a, Result b) {
        return Result.valueOf(a.getAsDouble() + b.getAsDouble());
    }

    public static Result sub(Result a, Result b) {
        return Result.valueOf(a.getAsDouble() - b.getAsDouble());
    }

    public static Result mul(Result a, Result b) {
        return Result.valueOf(a.getAsDouble() * b.getAsDouble());
    }

    public static Result div(Result a, Result b) {
        double divisor = b.getAsDouble();
        if (divisor != 0.0) {
            return Result.valueOf(a.getAsDouble() / divisor);
        }
        return Result.ZERO;
    }

    public static Result mod(Result a, Result b) {
        double divisor = b.getAsDouble();
        if (divisor != 0.0) {
            return Result.valueOf(a.getAsDouble() % divisor);
        }
        return Result.ZERO;
    }

    public static Result pow(Result a, Result b) {
        return Result.valueOf(Math.pow(a.getAsDouble(), b.getAsDouble()));
    }
}

