/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry.cube;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometry;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryFace;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModConfig;

public class SkinCubeFaceCuller {
    private static final int DIRECTION_SIZE = OpenDirection.values().length;
    private static final Map<SkinPartType, Partition> PARTITIONS2 = Collections.immutableMap(builder -> {
        builder.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new Simple(SkinPartTypes.BIPPED_HAT));
        builder.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new Simple(SkinPartTypes.BIPPED_HEAD));
        builder.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new Limb(SkinPartTypes.BIPPED_CHEST, SkinPartTypes.BIPPED_TORSO, 6));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new Limb(SkinPartTypes.BIPPED_LEFT_ARM, SkinPartTypes.BIPPED_LEFT_HAND, 4));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new Limb(SkinPartTypes.BIPPED_RIGHT_ARM, SkinPartTypes.BIPPED_RIGHT_HAND, 4));
        builder.put((Object)SkinPartTypes.BIPPED_SKIRT, (Object)new Simple(SkinPartTypes.BIPPED_SKIRT));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new Limb(SkinPartTypes.BIPPED_LEFT_THIGH, SkinPartTypes.BIPPED_LEFT_LEG, 6));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new Limb(SkinPartTypes.BIPPED_RIGHT_THIGH, SkinPartTypes.BIPPED_RIGHT_LEG, 6));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, (Object)new Simple(SkinPartTypes.BIPPED_LEFT_FOOT));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, (Object)new Simple(SkinPartTypes.BIPPED_RIGHT_FOOT));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_WING, (Object)new Simple(SkinPartTypes.BIPPED_LEFT_WING));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_WING, (Object)new Simple(SkinPartTypes.BIPPED_RIGHT_WING));
    });

    private static Partition getPartition(SkinPartType partType) {
        Partition partition;
        if (ModConfig.Client.enablePartSubdivide && (partition = PARTITIONS2.get(partType)) != null) {
            return partition;
        }
        return new Simple(partType);
    }

    public static Collection<SearchResult> allFaces(SkinGeometrySet<?> geometries, OpenRectangle3i bounds, SkinPartType partType) {
        SearchResult result = new SearchResult(partType, bounds, OpenVector3i.ZERO);
        for (int i = 0; i < geometries.size(); ++i) {
            SkinGeometry geometry = (SkinGeometry)geometries.get(i);
            result.addLog(geometry.getType());
            for (SkinGeometryFace skinGeometryFace : geometry.getFaces()) {
                result.addFace(skinGeometryFace);
            }
        }
        return Collections.singleton(result);
    }

    public static Collection<SearchResult> cullFaces2(SkinGeometrySet<?> geometries, OpenRectangle3i bounds, SkinPartType partType) {
        Collection<ISkinGeometryType> supportedTypes = geometries.getSupportedTypes();
        if (supportedTypes != null && (supportedTypes.contains(SkinGeometryTypes.CUBE) || supportedTypes.contains(SkinGeometryTypes.CUBE_CULL) || supportedTypes.contains(SkinGeometryTypes.MESH) || supportedTypes.contains(SkinGeometryTypes.MESH_CULL))) {
            return SkinCubeFaceCuller.allFaces(geometries, bounds, partType);
        }
        Partition partition = SkinCubeFaceCuller.getPartition(partType);
        IndexedMap indexedMap = new IndexedMap(geometries, bounds);
        Collection<SearchResult> results = partition.subdivide(bounds);
        for (SearchResult result : results) {
            result.cull(geometries, indexedMap);
        }
        for (int i = 0; i < geometries.size(); ++i) {
            SkinCube geometry = (SkinCube)geometries.get(i);
            for (SearchResult result : results) {
                result.addLog(geometry.getType());
                for (OpenDirection dir : OpenDirection.values()) {
                    SkinCubeFace face;
                    if (!result.flags.get(i * DIRECTION_SIZE + dir.get3DDataValue()) || (face = geometry.getFace(dir)) == null) continue;
                    result.addFace(face);
                }
            }
        }
        return results;
    }

    public static ArrayList<SkinGeometryFace> cullFaces(SkinGeometrySet<?> geometries, OpenRectangle3i bounds) {
        IndexedMap indexedMap = new IndexedMap(geometries, bounds);
        OpenRectangle3i rect = new OpenRectangle3i(0, 0, 0, bounds.width(), bounds.height(), bounds.depth());
        BitSet flags = SkinCubeFaceCuller.cullFaceFlags(geometries, indexedMap, rect);
        ArrayList<SkinGeometryFace> faces = new ArrayList<SkinGeometryFace>();
        for (int i = 0; i < geometries.size(); ++i) {
            SkinCube geometry = null;
            for (OpenDirection dir : OpenDirection.values()) {
                SkinCubeFace face;
                if (!flags.get(i * DIRECTION_SIZE + dir.get3DDataValue())) continue;
                if (geometry == null) {
                    geometry = (SkinCube)geometries.get(i);
                }
                if ((face = geometry.getFace(dir)) == null) continue;
                faces.add(face);
            }
        }
        return faces;
    }

    private static BitSet cullFaceFlags(SkinGeometrySet<?> geometries, IndexedMap map, OpenRectangle3i rect) {
        BitSet flags = new BitSet(geometries.size() * DIRECTION_SIZE);
        OpenRectangle3i searchArea = new OpenRectangle3i(rect.x() - 1, rect.y() - 1, rect.z() - 1, rect.width() + 2, rect.height() + 2, rect.depth() + 2);
        HashSet<OpenVector3i> closedSet = new HashSet<OpenVector3i>();
        ArrayDeque<OpenVector3i> openList = new ArrayDeque<OpenVector3i>();
        OpenVector3i start = searchArea.origin();
        openList.add(start);
        closedSet.add(start);
        map.limit(rect);
        while (!openList.isEmpty()) {
            ArrayList<OpenVector3i> pendingList = new ArrayList<OpenVector3i>();
            OpenVector3i pos = (OpenVector3i)openList.poll();
            for (OpenDirection advance : OpenDirection.values()) {
                OpenVector3i pos1 = pos.relative(advance, 1);
                int targetIndex = map.get(pos1);
                if (targetIndex == -1) {
                    pendingList.add(pos1);
                    continue;
                }
                boolean isBlank = false;
                ISkinGeometryType targetGeometryType = ((SkinGeometry)geometries.get(targetIndex)).getType();
                if (SkinGeometryTypes.isGlassBlock(targetGeometryType)) {
                    pendingList.add(pos1);
                    int sourceIndex = map.get(pos);
                    if (sourceIndex != -1) {
                        isBlank = SkinGeometryTypes.isGlassBlock(((SkinGeometry)geometries.get(sourceIndex)).getType());
                    }
                }
                OpenDirection facing = advance;
                if (advance.getAxis() == OpenDirection.Axis.Z) {
                    facing = advance.getOpposite();
                }
                flags.set(targetIndex * DIRECTION_SIZE + facing.get3DDataValue(), !isBlank);
            }
            for (OpenVector3i pos1 : pendingList) {
                if (!searchArea.contains(pos1) || closedSet.contains(pos1)) continue;
                closedSet.add(pos1);
                openList.add(pos1);
            }
        }
        return flags;
    }

    static interface Partition {
        public Collection<SearchResult> subdivide(OpenRectangle3i var1);
    }

    static class Simple
    implements Partition {
        final SkinPartType partType;

        public Simple(SkinPartType partType) {
            this.partType = partType;
        }

        @Override
        public Collection<SearchResult> subdivide(OpenRectangle3i rect) {
            OpenRectangle3i box = new OpenRectangle3i(0, 0, 0, rect.width(), rect.height(), rect.depth());
            return Collections.singleton(new SearchResult(this.partType, box, OpenVector3i.ZERO));
        }
    }

    public static class SearchResult {
        protected final SkinPartType partType;
        protected final OpenRectangle3i bounds;
        protected final OpenVector3i origin;
        protected BitSet flags;
        protected SkinUsedCounter usedCounter;
        protected ArrayList<SkinGeometryFace> faces = new ArrayList();

        public SearchResult(SkinPartType partType, OpenRectangle3i bounds, OpenVector3i origin) {
            this.usedCounter = new SkinUsedCounter();
            this.partType = partType;
            this.bounds = bounds;
            this.origin = origin;
        }

        public void addFace(SkinGeometryFace face) {
            this.faces.add(face);
        }

        public void addLog(ISkinGeometryType geometryType) {
            this.usedCounter.addGeometryType(geometryType);
        }

        public void cull(SkinGeometrySet<?> geometries, IndexedMap map) {
            this.flags = SkinCubeFaceCuller.cullFaceFlags(geometries, map, this.bounds);
        }

        public SkinPartType getPartType() {
            return this.partType;
        }

        public ArrayList<SkinGeometryFace> getFaces() {
            return this.faces;
        }

        public SkinUsedCounter getUsedCounter() {
            return this.usedCounter;
        }

        public OpenVector3i getOrigin() {
            return this.origin;
        }

        public OpenRectangle3i getBounds() {
            return this.bounds;
        }
    }

    public static class IndexedMap {
        public final int x;
        public final int y;
        public final int z;
        public final int width;
        public final int height;
        public final int depth;
        private final int[][][] indexes;
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;

        public IndexedMap(SkinGeometrySet<?> geometries, OpenRectangle3i bounds) {
            this.x = bounds.x();
            this.y = bounds.y();
            this.z = bounds.z();
            this.width = bounds.width();
            this.height = bounds.height();
            this.depth = bounds.depth();
            this.indexes = new int[this.depth][this.height][this.width];
            int size = geometries.size();
            for (int i = 0; i < size; ++i) {
                SkinCube geometry = (SkinCube)geometries.get(i);
                OpenVector3i blockPos = geometry.getBlockPos();
                int x = blockPos.x() - this.x;
                int y = blockPos.y() - this.y;
                int z = blockPos.z() - this.z;
                this.indexes[z][y][x] = i + 1;
            }
            this.limit(new OpenRectangle3i(0, 0, 0, this.width, this.height, this.depth));
        }

        public void limit(OpenRectangle3i limit) {
            this.minX = Math.max(limit.minX(), 0);
            this.minY = Math.max(limit.minY(), 0);
            this.minZ = Math.max(limit.minZ(), 0);
            this.maxX = Math.min(limit.maxX(), this.width);
            this.maxY = Math.min(limit.maxY(), this.height);
            this.maxZ = Math.min(limit.maxZ(), this.depth);
        }

        public int get(OpenVector3i pos) {
            return this.get(pos.x(), pos.y(), pos.z());
        }

        public int get(int x, int y, int z) {
            if (x < this.minX || x >= this.maxX) {
                return -1;
            }
            if (y < this.minY || y >= this.maxY) {
                return -1;
            }
            if (z < this.minZ || z >= this.maxZ) {
                return -1;
            }
            return this.indexes[z][y][x] - 1;
        }
    }

    static class Limb
    extends Simple {
        final SkinPartType upperPartType;
        final SkinPartType lowerPartType;
        final int yClip;

        public Limb(SkinPartType upperPartType, SkinPartType lowerPartType, int yClip) {
            super(upperPartType);
            this.upperPartType = upperPartType;
            this.lowerPartType = lowerPartType;
            this.yClip = yClip;
        }

        @Override
        public Collection<SearchResult> subdivide(OpenRectangle3i rect) {
            int upper = this.yClip - rect.minY();
            int lower = rect.maxY() - this.yClip;
            if (lower > 0 && upper > 0) {
                OpenRectangle3i upperBox = new OpenRectangle3i(0, 0, 0, rect.width(), upper, rect.depth());
                OpenRectangle3i lowerBox = new OpenRectangle3i(0, upper, 0, rect.width(), lower, rect.depth());
                SearchResult upperResult = new SearchResult(this.upperPartType, upperBox, OpenVector3i.ZERO);
                SearchResult lowerResult = new SearchResult(this.lowerPartType, lowerBox, new OpenVector3i(0, -this.yClip, 0));
                return Collections.newList(upperResult, lowerResult);
            }
            return super.subdivide(rect);
        }
    }
}

