/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry.cube;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryFace;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryVertex;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeVertex;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class SkinCubeFace
extends SkinGeometryFace {
    public final int alpha;
    private final ISkinGeometryType type;
    private final OpenDirection direction;
    private final SkinPaintColor paintColor;
    private final OpenRectangle3f boundingBox;

    public SkinCubeFace(int id, ISkinGeometryType type, OpenTransform3f transform, SkinTexturePos texturePos, OpenRectangle3f boundingBox, OpenDirection direction, SkinPaintColor color, int alpha) {
        this.id = id;
        this.type = type;
        this.transform = transform;
        this.texturePos = texturePos;
        this.paintColor = color;
        this.alpha = alpha;
        this.direction = direction;
        this.boundingBox = boundingBox;
    }

    public static float[][] getBaseUVs(OpenDirection direction, int rot) {
        return switch (rot) {
            case 90 -> Helper.UVS_90[direction.get3DDataValue()];
            case 180 -> Helper.UVS_180[direction.get3DDataValue()];
            case 270 -> Helper.UVS_270[direction.get3DDataValue()];
            default -> Helper.UVS[direction.get3DDataValue()];
        };
    }

    public static float[][] getBaseVertices(OpenDirection direction) {
        return Helper.VERTICES[direction.get3DDataValue()];
    }

    public OpenRectangle3f getBoundingBox() {
        return this.boundingBox;
    }

    public SkinPaintColor getColor() {
        return this.paintColor;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public OpenDirection getDirection() {
        return this.direction;
    }

    public SkinPaintType getPaintType() {
        return this.paintColor.getPaintType();
    }

    @Override
    public ISkinGeometryType getType() {
        return this.type;
    }

    @Override
    public SkinTexturePos getTexturePos() {
        if (this.texturePos != null) {
            return this.texturePos;
        }
        return this.paintColor.getPaintType().getTexturePos();
    }

    @Override
    public float getPriority() {
        return this.direction.get3DDataValue();
    }

    @Override
    public boolean isVisible() {
        return this.paintColor.getPaintType() != SkinPaintTypes.NONE;
    }

    @Override
    public Iterable<? extends SkinGeometryVertex> getVertices() {
        int id = this.getId();
        SkinTexturePos texturePos = this.getTexturePos();
        int textureRotation = this.getTextureRotation(texturePos);
        float x = this.boundingBox.x();
        float y = this.boundingBox.y();
        float z = this.boundingBox.z();
        float w = this.roundUp(this.boundingBox.width());
        float h = this.roundUp(this.boundingBox.height());
        float d = this.roundUp(this.boundingBox.depth());
        float u = texturePos.getU();
        float v = texturePos.getV();
        float s = this.roundDown(texturePos.getWidth());
        float t = this.roundDown(texturePos.getHeight());
        SkinGeometryVertex.Color color = new SkinGeometryVertex.Color(this.paintColor, this.alpha);
        ArrayList<SkinCubeVertex> vertices = new ArrayList<SkinCubeVertex>();
        float[][] vertexes = SkinCubeFace.getBaseVertices(this.direction);
        float[][] uvs = SkinCubeFace.getBaseUVs(this.direction, textureRotation);
        for (int i = 0; i < 4; ++i) {
            OpenVector3f position = new OpenVector3f(x + w * vertexes[i][0], y + h * vertexes[i][1], z + d * vertexes[i][2]);
            OpenVector3f normal = new OpenVector3f(vertexes[4][0], vertexes[4][1], vertexes[4][2]);
            OpenVector2f textureCoords = new OpenVector2f(u + s * uvs[i][0], v + t * uvs[i][1]);
            vertices.add(new SkinCubeVertex(id * 4 + i, position, normal, textureCoords, color, this));
        }
        return vertices;
    }

    private float roundUp(float edg) {
        if (edg == 0.0f) {
            return 1.0E-4f;
        }
        return edg;
    }

    private float roundDown(float edg) {
        if (edg < 0.0f) {
            return edg + 1.0E-4f;
        }
        return edg - 1.0E-4f;
    }

    private int getTextureRotation(SkinTexturePos key) {
        SkinTextureOptions options = key.getOptions();
        if (options != null) {
            return options.getRotation();
        }
        return 0;
    }

    private static class Helper {
        public static final float[][][] VERTICES = new float[][][]{new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}}, new float[][]{{1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}}};
        public static final float[][][] UVS = new float[][][]{new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}};
        public static final float[][][] UVS_90 = new float[][][]{new float[][]{{1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}}};
        public static final float[][][] UVS_180 = new float[][][]{new float[][]{{0.0f, 1.0f}, {0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}}};
        public static final float[][][] UVS_270 = new float[][][]{new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}}, new float[][]{{1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}}, new float[][]{{1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}}, new float[][]{{1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}}, new float[][]{{1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}}, new float[][]{{1.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}}};

        private Helper() {
        }
    }
}

