/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry.cube;

import java.util.EnumMap;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometry;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import org.jetbrains.annotations.Nullable;

public abstract class SkinCube
extends SkinGeometry {
    protected OpenRectangle3f boundingBox = OpenRectangle3f.ZERO;
    protected final EnumMap<OpenDirection, SkinPaintColor> paintColors = new EnumMap(OpenDirection.class);

    public void setType(ISkinGeometryType type) {
        throw new UnsupportedOperationException();
    }

    public void setBoundingBox(OpenRectangle3f box) {
        throw new UnsupportedOperationException();
    }

    public void setPaintColor(OpenDirection dir, SkinPaintColor paintColor) {
        throw new UnsupportedOperationException();
    }

    public OpenRectangle3f getBoundingBox() {
        return this.boundingBox;
    }

    public SkinPaintColor getPaintColor(OpenDirection dir) {
        return this.paintColors.getOrDefault(dir, SkinPaintColor.CLEAR);
    }

    public abstract SkinTexturePos getTexture(OpenDirection var1);

    @Nullable
    public SkinCubeFace getFace(OpenDirection dir) {
        int id = dir.get3DDataValue();
        SkinTexturePos texturePos = this.getTexture(dir);
        SkinPaintColor paintColor = this.getPaintColor(dir);
        ISkinGeometryType geometryType = this.getType();
        int alpha = 255;
        if (SkinGeometryTypes.isGlassBlock(geometryType)) {
            alpha = 127;
        }
        OpenTransform3f transform = this.getTransform();
        OpenRectangle3f boundingBox = this.getBoundingBox();
        return new SkinCubeFace(id, geometryType, transform, texturePos, boundingBox, dir, paintColor, alpha);
    }

    @Override
    public OpenVoxelShape getShape() {
        return OpenVoxelShape.box(this.getBoundingBox());
    }

    public Iterable<SkinCubeFace> getFaces() {
        return Collections.compactMap(OpenDirection.values(), this::getFace);
    }

    public OpenVector3i getBlockPos() {
        OpenRectangle3f boundingBox = this.getBoundingBox();
        return new OpenVector3i(boundingBox.x(), boundingBox.y(), boundingBox.z());
    }
}

