/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry.collection;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v12.LegacyCubeHelper;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class SkinGeometrySetV1
extends SkinGeometrySet<SkinCube> {
    private static final int STRIDE_SIZE = 28;
    private final byte[] bytes;
    private final int cubeTotal;
    private final ThreadLocal<BufferSlice> bufferSlice;

    public SkinGeometrySetV1(int count) {
        this.bytes = new byte[count * 28];
        this.cubeTotal = count;
        this.bufferSlice = ThreadLocal.withInitial(() -> new BufferSlice(this.bytes, 28));
    }

    public static void writeToStream(SkinGeometrySet<?> geometries, IOutputStream stream) throws IOException {
        if (geometries instanceof SkinGeometrySetV1) {
            SkinGeometrySetV1 cubes1 = (SkinGeometrySetV1)geometries;
            stream.writeInt(geometries.size());
            stream.write(cubes1.bytes);
            return;
        }
        ISkinPaintColor[] paintColors = new ISkinPaintColor[6];
        stream.writeInt(geometries.size());
        for (SkinCube geometry : Collections.collect(geometries, SkinCube.class)) {
            OpenVector3i blockPos = geometry.getBlockPos();
            stream.writeByte(geometry.getType().getId());
            stream.writeByte(blockPos.x());
            stream.writeByte(blockPos.y());
            stream.writeByte(blockPos.z());
            for (OpenDirection dir : OpenDirection.values()) {
                SkinPaintColor paintColor = geometry.getPaintColor(dir);
                paintColors[dir.get3DDataValue()] = paintColor;
            }
            for (int side = 0; side < 6; ++side) {
                ISkinPaintColor paintColor = paintColors[side];
                stream.writeInt(paintColor.getRawValue());
            }
        }
    }

    public static SkinGeometrySetV1 readFromStream(IInputStream stream, int version, SkinPartType skinPart) throws IOException, InvalidCubeTypeException {
        int size = stream.readInt();
        SkinGeometrySetV1 geometries = new SkinGeometrySetV1(size);
        BufferSlice bufferSlice = geometries.bufferSlice.get();
        if (version >= 10) {
            byte[] bytes = bufferSlice.getBytes();
            stream.read(bytes, 0, size * bufferSlice.stride);
            for (int i = 0; i < size; ++i) {
                BufferSlice slice = bufferSlice.at(i);
                if (version >= 11) continue;
                for (int side = 0; side < 6; ++side) {
                    slice.setPaintType(side, (byte)-1);
                }
            }
            return geometries;
        }
        for (int i = 0; i < size; ++i) {
            BufferSlice slice = bufferSlice.at(i);
            LegacyCubeHelper.loadLegacyCubeData(geometries, slice, stream, version, skinPart);
            for (int side = 0; side < 6; ++side) {
                slice.setPaintType(side, (byte)-1);
            }
        }
        return geometries;
    }

    @Override
    public SkinCube get(int index) {
        return this.bufferSlice.get().at(index);
    }

    @Override
    public int size() {
        return this.cubeTotal;
    }

    public static class BufferSlice
    extends SkinCube {
        private final int stride;
        private final byte[] bytes;
        int writerIndex = 0;
        int readerIndex = 0;

        public BufferSlice(byte[] bytes, int stride) {
            this.bytes = bytes;
            this.stride = stride;
        }

        public BufferSlice at(int index) {
            this.writerIndex = index * this.stride;
            this.readerIndex = index * this.stride;
            return this;
        }

        public byte getId() {
            return this.getByte(0);
        }

        public void setId(byte id) {
            this.setByte(0, id);
        }

        public byte getX() {
            return this.getByte(1);
        }

        public void setX(byte value) {
            this.setByte(1, value);
        }

        public byte getY() {
            return this.getByte(2);
        }

        public void setY(byte value) {
            this.setByte(2, value);
        }

        public byte getZ() {
            return this.getByte(3);
        }

        public void setZ(byte value) {
            this.setByte(3, value);
        }

        public void setR(int side, byte value) {
            this.setByte(4 + side * 4, value);
        }

        public byte getR(int side) {
            return this.getByte(4 + side * 4);
        }

        public void setG(int side, byte value) {
            this.setByte(5 + side * 4, value);
        }

        public byte getG(int side) {
            return this.getByte(5 + side * 4);
        }

        public void setB(int side, byte value) {
            this.setByte(6 + side * 4, value);
        }

        public byte getB(int side) {
            return this.getByte(6 + side * 4);
        }

        public void setPaintType(int side, byte value) {
            this.setByte(7 + side * 4, value);
        }

        public byte getPaintType(int side) {
            return this.getByte(7 + side * 4);
        }

        public int getRGB(int side) {
            int color = 0;
            color |= (this.getR(side) & 0xFF) << 16;
            color |= (this.getG(side) & 0xFF) << 8;
            return color |= this.getB(side) & 0xFF;
        }

        public void setRGB(int side, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            this.setR(side, (byte)r);
            this.setG(side, (byte)g);
            this.setB(side, (byte)b);
        }

        public int getColor(int side) {
            byte type = this.getPaintType(side);
            int rgb = this.getRGB(side);
            return rgb & 0xFFFFFF | (type & 0xFF) << 24;
        }

        @Override
        public void setBoundingBox(OpenRectangle3f boundingBox) {
            OpenVector3i blockPos = new OpenVector3i(boundingBox.x(), boundingBox.y(), boundingBox.z());
            this.setX((byte)blockPos.x());
            this.setY((byte)blockPos.y());
            this.setZ((byte)blockPos.z());
        }

        @Override
        public OpenRectangle3f getBoundingBox() {
            float x = this.getX();
            float y = this.getY();
            float z = this.getZ();
            return new OpenRectangle3f(x, y, z, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void setType(ISkinGeometryType type) {
            this.setId((byte)type.getId());
        }

        @Override
        public ISkinGeometryType getType() {
            return SkinGeometryTypes.byId(this.getId());
        }

        @Override
        public void setPaintColor(OpenDirection dir, SkinPaintColor paintColor) {
            int side = dir.get3DDataValue();
            int type = paintColor.getPaintType().getId();
            int rgb = paintColor.getRGB();
            this.setPaintType(side, (byte)type);
            this.setRGB(side, rgb);
        }

        @Override
        public SkinPaintColor getPaintColor(OpenDirection dir) {
            int side = dir.get3DDataValue();
            byte type = this.getPaintType(side);
            int rgb = this.getRGB(side);
            return SkinPaintColor.of(rgb, SkinPaintTypes.byId(type));
        }

        @Override
        public SkinTexturePos getTexture(OpenDirection dir) {
            return null;
        }

        public void setByte(int offset, byte value) {
            this.bytes[this.writerIndex + offset] = value;
        }

        public byte getByte(int offset) {
            return this.bytes[this.readerIndex + offset];
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

