/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.world.level.block.Block;

public final class SkinGeometryTypes {
    private static final SkinGeometryType[] ALL_GEOMETRY_TYPE_MAPPING = new SkinGeometryType[256];
    private static final LinkedHashMap<String, SkinGeometryType> ALL_GEOMETRY_TYPES = new LinkedHashMap();
    public static final ISkinGeometryType BLOCK_SOLID = SkinGeometryTypes.register("solid", 0, ModBlocks.SKIN_CUBE);
    public static final ISkinGeometryType BLOCK_GLOWING = SkinGeometryTypes.register("glowing", 1, ModBlocks.SKIN_CUBE_GLOWING);
    public static final ISkinGeometryType BLOCK_GLASS = SkinGeometryTypes.register("glass", 2, ModBlocks.SKIN_CUBE_GLASS);
    public static final ISkinGeometryType BLOCK_GLASS_GLOWING = SkinGeometryTypes.register("glass_glowing", 3, ModBlocks.SKIN_CUBE_GLASS_GLOWING);
    public static final ISkinGeometryType CUBE = SkinGeometryTypes.register("cube", 4, ModBlocks.BOUNDING_BOX);
    public static final ISkinGeometryType CUBE_CULL = SkinGeometryTypes.register("cube_cull", 6, ModBlocks.BOUNDING_BOX);
    public static final ISkinGeometryType MESH = SkinGeometryTypes.register("mesh", 5, ModBlocks.BOUNDING_BOX);
    public static final ISkinGeometryType MESH_CULL = SkinGeometryTypes.register("mesh_cull", 7, ModBlocks.BOUNDING_BOX);

    public static ISkinGeometryType byName(String name) {
        SkinGeometryType cube = ALL_GEOMETRY_TYPES.get(name);
        if (cube != null) {
            return cube;
        }
        return BLOCK_SOLID;
    }

    public static ISkinGeometryType byId(int index) {
        SkinGeometryType cubeType = ALL_GEOMETRY_TYPE_MAPPING[index & 0xFF];
        if (cubeType != null) {
            return cubeType;
        }
        return BLOCK_SOLID;
    }

    public static ISkinGeometryType byBlock(Block block) {
        for (SkinGeometryType cubeType : ALL_GEOMETRY_TYPES.values()) {
            if (cubeType.getBlock() != block) continue;
            return cubeType;
        }
        return BLOCK_SOLID;
    }

    public static boolean isGlassBlock(ISkinGeometryType geometryType) {
        return geometryType == BLOCK_GLASS || geometryType == BLOCK_GLASS_GLOWING;
    }

    public static boolean isGlowingBlock(ISkinGeometryType geometryType) {
        return geometryType == BLOCK_GLOWING || geometryType == BLOCK_GLASS_GLOWING;
    }

    private static SkinGeometryType register(String name, int id, IRegistryHolder<Block> block) {
        SkinGeometryType geometryType = new SkinGeometryType(id, block);
        geometryType.setRegistryName(OpenResourceLocation.create("armourers", name));
        if (ALL_GEOMETRY_TYPES.containsKey(geometryType.getRegistryName().toString())) {
            ModLog.warn("A mod tried to register a geometry type with an id that is in use.", new Object[0]);
            return geometryType;
        }
        ALL_GEOMETRY_TYPES.put(geometryType.getRegistryName().toString(), geometryType);
        SkinGeometryTypes.ALL_GEOMETRY_TYPE_MAPPING[geometryType.getId() & 0xFF] = geometryType;
        ModLog.debug("Registering Skin Cube '{}'", geometryType.getRegistryName());
        return geometryType;
    }

    public static int getTotalCubes() {
        return ALL_GEOMETRY_TYPES.size();
    }
}

